package promise

import (
	"errors"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestNewAny(t *testing.T) {
	expected := errors.New("expected")
	a := NewAny()
	assert.True(t, a.WouldBlock())
	a.Set(true, expected)
	assert.NotPanics(t, func() {
		a.Set(false, expected)
		a.Set(false, nil)
	})
	assert.False(t, a.WouldBlock())
	result, err := a.Get()
	assert.Equal(t, result, true)
	assert.Equal(t, expected, err)
}
