package promise

// NewBool creates an unset MutableBool
func NewBool() MutableBool {
	return &asyncBool{src: NewAny()}
}

type asyncBool struct {
	src MutableAny
}

func (a *asyncBool) WouldBlock() bool          { return a.src.WouldBlock() }
func (a *asyncBool) Get() (interface{}, error) { return a.src.Get() }
func (a *asyncBool) Result() (bool, error) {
	result, err := a.src.Get()
	cast, ok := result.(bool)
	return ok && cast, err
}

func (a *asyncBool) Set(result bool, err error) {
	a.src.Set(result, err)
}
