package promise

// Bool exends Any with a typed Result() call. It should be used as an example for how to properly cast extend Any for other concrete result types.
type Bool interface {
	Any
	Result() (bool, error)
}

// MutableBool extends Bool to allow it to be set asynchronously. Note that this interface does *not* extend MutableAny, which would incorrectly allow
// setting illegal types.
type MutableBool interface {
	Bool
	Set(bool, error)
}
