# CDK Infrastructure

[AWS CDK](https://docs.aws.amazon.com/cdk/latest/guide/getting_started.html#getting_started_install) project to define the infrastructure for this project.

## Requirements

- [Node.js](https://nodejs.org/): Using [nodenv](https://github.com/nodenv/nodenv) is recommended, and will automatically use the correct version of Node. If `nodenv` is not available, use the version of Node specified in `.node-version`.
- `mwinit`: to authenticate with Isengard. See https://wiki.twitch.com/display/AD/Using+Isengard+from+the+command+line+or+programatically for details.

### NPM commands

- `npm install`: Install and upgrade dependencies. Run this to install dependencies.
- `npm install @aws-cdk/aws-ecs`: Add a new dependency.
- `npm install @aws-cdk/aws-ecs@0.36.0`: Upgrade a package to the latest version `^0.36.0`. Note that it is common to upgrade all cdk dependencies together. You can also update versinos in package.json and then do `npm install`.

### CDK commands

You must execute CDK using `npx cdk` to use the project-local version. Do not use a globally installed version of `cdk`.

- `npx cdk ls`: List stacks. You can filter with expressions like `npx cdk ls 'Dev*'`.
- `npx cdk diff [<Stack>...]`: Compare changes with deployed CloudFormation stacks. CDK does not detect drift, only stack changes.
- `npx cdk synth [<Stack>...]`: Visualize the synthesized CloudFormation template.
- `npx cdk deploy [<Stack>...]`: Deploy stacks with CloudFormation.