package connectionsWrapper

import (
	"context"
	"net/http"

	"code.justin.tv/foundation/twitchclient"
	connections "code.justin.tv/identity/connections/client"
	"code.justin.tv/sse/malachai/pkg/s2s/caller"
)

type ConnectionsClient interface {
	GetBlizzardUser(context.Context, string) (*connections.BlizzardUser, error)
}

type connectionsClient struct {
	Client connections.Client
}

func NewConnectionsClient() (ConnectionsClient, error) {
	rtConfig := &caller.Config{}
	rt, err := caller.NewRoundTripper("mdaas-ingest-dev", rtConfig, nil)
	if err != nil {
		return nil, err
	}

	connectionsConf := twitchclient.ClientConf{
		Host: "https://staging.connections.twitch.a2z.com",
		RoundTripperWrappers: []func(http.RoundTripper) http.RoundTripper{
			func(inner http.RoundTripper) (outer http.RoundTripper) {
				rt.SetInnerRoundTripper(inner)
				return rt
			},
		},
	}

	c, err := connections.NewClient(connectionsConf)
	if err != nil {
		return nil, err
	}

	return &connectionsClient{
		Client: c,
	}, nil
}

func (c connectionsClient) GetBlizzardUser(ctx context.Context, userID string) (*connections.BlizzardUser, error) {
	return c.Client.GetBlizzardUser(ctx, userID, nil)
}
