package main

import (
	"context"
	"encoding/json"
	"fmt"
	"math/rand"
	"os"
	"time"

	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	cw "code.justin.tv/amzn/TwitchTelemetryCloudWatchMetricsSender"
	"git.xarth.tv/devhub/loadtester/attack"
	"git.xarth.tv/devhub/loadtester/connectionsWrapper"
	"git.xarth.tv/devhub/loadtester/targets"
	log "github.com/sirupsen/logrus"
	vegeta "github.com/tsenart/vegeta/v12/lib"
)

func rangeIn(low, hi int) int {
	return low + rand.Intn(hi-low)
}

func main() {
	log.Println("**** Starting load test 1000rps ****")

	tPid := &identifier.ProcessIdentifier{
		Service:  "LoadTester",
		Stage:    "dev",
		Substage: "primary",
		Region:   "us-west-2",
		// Machine:  "SomeUniqueMachineIdentifier",
	}
	sender := cw.NewUnbuffered(tPid, nil)
	sampleObserver := telemetry.NewBufferedAggregator(30*time.Second, 100000, time.Minute, sender, nil)
	sampleReporter := telemetry.SampleReporter{
		SampleBuilder:  telemetry.SampleBuilder{ProcessIdentifier: *tPid},
		SampleObserver: sampleObserver,
	}

	connectionsClient, err := connectionsWrapper.NewConnectionsClient() //connectionsClient
	if err != nil {
		log.Error(err)
		os.Exit(0)
	}

	rate := vegeta.Rate{Freq: 500, Per: time.Second}
	duration := 10 * time.Minute
	targeter := targets.NewStaticTargeter(targets.Target{
		Method: func() (string, error) {
			sampleReporter.Report(fmt.Sprintf("Request"), 1.0, telemetry.UnitCount)
			//r, rerr := connectionsClient.(context.Background(), fmt.Sprint(rangeIn(1000000, 99999999)))
			r, rerr := connectionsClient.GetBlizzardUser(context.Background(), "50295775") //fmt.Sprint(rangeIn(1000000, 99999999)))

			out, err := json.Marshal(r)
			if err != nil {
				log.Error(err)
				panic(err)
			}

			return string(out), rerr
		},
	})

	attacker := attack.NewAttacker()

	var vMetrics vegeta.Metrics
	for res := range attacker.Attack(targeter, rate, duration, "Big Bang!") {
		// log.Println(res.Error)
		// log.Println(res.Code)
		sampleReporter.Report(fmt.Sprintf("Response_code_%s", fmt.Sprint(res.Code)), 1.0, telemetry.UnitCount)
		vMetrics.Add(res)
	}
	vMetrics.Close()

	sampleReporter.Report(fmt.Sprintf("Requests"), float64(vMetrics.Requests), telemetry.UnitCount)
	// sampleReporter.Report(fmt.Sprintf("99th percentile"), float64(vMetrics.Latencies.P99), telemetry.MetricDuration)

	log.Println("99th percentile: %s\n", vMetrics.Latencies.P99)
	log.Println("StatusCodes: %v\n", vMetrics.StatusCodes)
	log.Println("Requests: %v\n", vMetrics.Requests)
}
