package metrics

import (
	"time"

	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	cw "code.justin.tv/amzn/TwitchTelemetryCloudWatchMetricsSender"
)

const (
	flushPeriod       = 30 * time.Second
	bufferSize        = 100000
	aggregationPeriod = time.Minute
)

var observer telemetry.SampleObserver
var reporter *telemetry.SampleReporter

type noopObs struct{}

func (no *noopObs) ObserveSample(s *telemetry.Sample) {}
func (no *noopObs) Flush()                            {}
func (no *noopObs) Stop()                             {}

func init() {
	observer = &noopObs{}
	reporter = &telemetry.SampleReporter{
		SampleBuilder:  telemetry.SampleBuilder{ProcessIdentifier: identifier.ProcessIdentifier{}},
		SampleObserver: observer,
	}
}

func InitializeMetrics(l *FLogger, processor *identifier.ProcessIdentifier) {
	sender := cw.NewUnbuffered(processor, l)
	observer = telemetry.NewBufferedAggregator(flushPeriod, bufferSize, aggregationPeriod, sender, l)
	reporter = &telemetry.SampleReporter{
		SampleBuilder:  telemetry.SampleBuilder{ProcessIdentifier: *processor},
		SampleObserver: observer,
	}
}

func Observer() telemetry.SampleObserver {
	return observer
}

func Reporter() *ReporterWithDimensions {
	return &ReporterWithDimensions{
		SampleReporter: *reporter,
	}
}

func GetDurationByMS(timestamp int64) float64 {
	diff := time.Now().UnixNano() - timestamp
	return float64(diff) / float64(time.Second)
}
