package metrics

import (
	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"
	telemetry "code.justin.tv/amzn/TwitchTelemetry"

	"time"

	agent "code.justin.tv/amzn/TwitchTelemetrySystemMetricsCollector"
)

func StartSystemStatsCollection(l *FLogger, processIdentifier *identifier.ProcessIdentifier, observer telemetry.SampleObserver) {
	systemMetricsConfig := agent.SystemMetricsCollectorConfig{
		Collectors: []agent.SystemMetricsCollector{agent.CPUCollector, agent.NetCollector, agent.DiskCollector, agent.DiskIOCollector, agent.MemCollector, agent.LoadCollector},
		PerCPU:     true,
	}
	systemMetricsPoller := agent.NewSystemMetricsPollingCollector(systemMetricsConfig, 10*time.Second, processIdentifier, observer, nil)
	systemMetricsPoller.Start()

}
