# Discovery Tags Validator Lambda
Tags Validate Lambda for MDaaS Discovery integration. It serves to validate metadata tags so publish them to a Tags SNS topic so they can be consumed by Discovery

## Slack
Feel free to ping #mdaas channel for all your questions not answered below.

## Docs
- [MDaaS Tech Spec](https://docs.google.com/document/d/1RsnJ4DGcYvYuV_1E9wneZtfeiBMTbpyYclEqAsIYy08/edit?usp=sharing)

## Related Repo
- [MDaaS Ingest](https://git-aws.internal.justin.tv/devhub/mdaas-ingest "MDaaS Ingest")
- [MDaaS Infra](https://git-aws.internal.justin.tv/devhub/mdaas-infra)

## Getting Started
### Setup
Run `make setup`

## Tests
Run `make test`

## PR and Deployment Guidelines
### Submitting PR
- Create a PR to merge to develop branch (DO NOT MERGE TO MASTER DIRECTLY!!!)
- Follow the PR template to fill in your pull request details
- Get PR Approved and merged to develop
- You should make sure it is working as expected on staging

### Deployment
- You PR will be automatically deployed to Staging if merged to develop branch
- Then you submit a new PR after that to merge into master from develop
- No reviews needed
- After you merge to master, you should go to #mdaas-deploys and see there is a Deploy button under the notification
- Click the Deploy button to Jenkins and click Proceed on the pending box
- Then production deployment will start.
- Notifications will post in #mdaas-deploys when your prod deployment is done.

### Tips
- The button click should be within 5 min, time exceeding that will be a timeout, and you will need to rebuild to trigger deploy.
- If you accidentally merge to master before to develop, make them in sync again. The two branches should be in sync, or at least master should not advance develop.

## E2E Tests
Todo

## Infrastructure and tools
- Logs will be stored using Cloudwatch.
- Metrics will be published via Cloudwatch.
- AWS Secret Manager is used to store credentials.
- Infra is built using CDK and using [AWS Lambda](https://aws.amazon.com/lambda/) and [S3](https://aws.amazon.com/s3/)

Please refer to [MDaaS-Infra](https://git-aws.internal.justin.tv/devhub/mdaas-infra)

## Dashboards
- Please go to twitch-mdaas-ingest-prod AWS account's CloudWatch dashboard "MDaaS-Overview" for metrics and dashboards.
- [Discovery dashboard for auto-tag feature](https://grafana.internal.justin.tv/d/000001156/discovery-graffiti?orgId=1&from=now-12h&to=now&panelId=176&fullscreen&edit&var-environment=canary-production&var-environment=production&var-endpoint=GetBulkContentTags&var-redis_op=All&var-service=Graffiti)

## Oncall Runbook
Please refer to [Oncall Runbook](https://git-aws.internal.justin.tv/devhub/mdaas-ingest/blob/develop/docs/oncall-runbook.md)
