package sns

import "time"

type Config struct {
	AWSRegion  string
	RetryDelay time.Duration
	RetryCount int
}

const (
	defaultRetryDelay = 100 * time.Millisecond
	defaultRetryCount = 10
)

func (c *Config) retryDelay() time.Duration {
	if c.RetryDelay == 0 {
		return defaultRetryDelay
	}
	return c.RetryDelay
}

func (c *Config) retryCount() int {
	if c.RetryCount == 0 {
		return defaultRetryCount
	}
	return c.RetryCount
}
