package main

import (
	"context"
	"encoding/json"
	"os"

	"code.justin.tv/devhub/mdaas-discovery-tags-validator/internal/clients/sns"
	models "code.justin.tv/devhub/mdaas-discovery-tags-validator/models"
	processor "code.justin.tv/devhub/mdaas-discovery-tags-validator/processor"
	"github.com/aws/aws-lambda-go/events"
	"github.com/aws/aws-lambda-go/lambda"
	log "github.com/sirupsen/logrus"
)

// HandRequest does the work
func HandleRequest(ctx context.Context, snsEvent events.SNSEvent) {
	devTagsTopicArn := os.Getenv("DEV_TAGS_TOPIC_ARN")
	prodTagsTopicArn := os.Getenv("PROD_TAGS_TOPIC_ARN")

	log.SetFormatter(&log.JSONFormatter{})

	snsClient, err := sns.NewPublisher(sns.Config{
		AWSRegion: "us-west-2",
	})
	if err != nil {
		log.Error(err)
		return
	}

	processor := processor.NewProcessor(snsClient, prodTagsTopicArn, devTagsTopicArn)

	for _, record := range snsEvent.Records {

		gameData := models.GameData{}

		if err := json.Unmarshal([]byte(record.SNS.Message), &gameData); err != nil {
			log.Error(err)
		}

		processor.Process(gameData)
	}
}

func main() {
	lambda.Start(HandleRequest)
}
