package models

type MetadataDelta struct {
	ID      string    `json:"id"`
	Tags    TagsDelta `json:"tags"`
	Active  bool      `json:"action"`
	Refresh bool      `json:"refresh"`
}

type TagsDelta struct {
	Added   []string `json:"add"`
	Removed []string `json:"remove"`
}

type DiscoveryMessage struct {
	ChannelID string   `json:"channel_id"`
	Add       []string `json:"add"`
	Remove    []string `json:"remove"`
}

type GameData struct {
	BroadcasterIDs []string      `json:"broadcaster_ids"`
	Env            string        `json:"env"`
	GameID         string        `json:"id"`
	MetadataDelta  MetadataDelta `json:"metadata_delta"`
}
