
# Package naiive
Package naiive implements a simple regex based static analysis tool for Go


```shell

	$ go get -u code.justin.tv/tshadwell/nice/naiive
```

## Contents
1. [Contents](#contents)
2. [Doc](#doc)
	1. [func CombineRegex(prefix string, r []*regexp.Regexp) (combined *regexp.Regexp, err error)](#CombineRegex)
	2. [var DefaultTests Tests](#DefaultTests)
	3. [type ErrNoSuchTest](#ErrNoSuchTest)
		1. [func Error() string](#ErrNoSuchTest.Error)
	4. [type Test](#Test)
		1. [func regexp.Copy() *regexp.Regexp](#Test.regexp.Copy)
		2. [func regexp.Expand(regexp.dst []byte, regexp.template []byte, regexp.src []byte, regexp.match []int) []byte](#Test.regexp.Expand)
		3. [func regexp.ExpandString(regexp.dst []byte, regexp.template string, regexp.src string, regexp.match []int) []byte](#Test.regexp.ExpandString)
		4. [func regexp.Find(regexp.b []byte) []byte](#Test.regexp.Find)
		5. [func regexp.FindAll(regexp.b []byte, regexp.n int) [][]byte](#Test.regexp.FindAll)
		6. [func regexp.FindAllIndex(regexp.b []byte, regexp.n int) [][]int](#Test.regexp.FindAllIndex)
		7. [func regexp.FindAllString(regexp.s string, regexp.n int) []string](#Test.regexp.FindAllString)
		8. [func regexp.FindAllStringIndex(regexp.s string, regexp.n int) [][]int](#Test.regexp.FindAllStringIndex)
		9. [func regexp.FindAllStringSubmatch(regexp.s string, regexp.n int) [][]string](#Test.regexp.FindAllStringSubmatch)
		10. [func regexp.FindAllStringSubmatchIndex(regexp.s string, regexp.n int) [][]int](#Test.regexp.FindAllStringSubmatchIndex)
		11. [func regexp.FindAllSubmatch(regexp.b []byte, regexp.n int) [][][]byte](#Test.regexp.FindAllSubmatch)
		12. [func regexp.FindAllSubmatchIndex(regexp.b []byte, regexp.n int) [][]int](#Test.regexp.FindAllSubmatchIndex)
		13. [func regexp.FindIndex(regexp.b []byte) (regexp.loc []int)](#Test.regexp.FindIndex)
		14. [func regexp.FindReaderIndex(regexp.r io.RuneReader) (regexp.loc []int)](#Test.regexp.FindReaderIndex)
		15. [func regexp.FindReaderSubmatchIndex(regexp.r io.RuneReader) []int](#Test.regexp.FindReaderSubmatchIndex)
		16. [func regexp.FindString(regexp.s string) string](#Test.regexp.FindString)
		17. [func regexp.FindStringIndex(regexp.s string) (regexp.loc []int)](#Test.regexp.FindStringIndex)
		18. [func regexp.FindStringSubmatch(regexp.s string) []string](#Test.regexp.FindStringSubmatch)
		19. [func regexp.FindStringSubmatchIndex(regexp.s string) []int](#Test.regexp.FindStringSubmatchIndex)
		20. [func regexp.FindSubmatch(regexp.b []byte) [][]byte](#Test.regexp.FindSubmatch)
		21. [func regexp.FindSubmatchIndex(regexp.b []byte) []int](#Test.regexp.FindSubmatchIndex)
		22. [func regexp.LiteralPrefix() (regexp.prefix string, regexp.complete bool)](#Test.regexp.LiteralPrefix)
		23. [func regexp.Longest()](#Test.regexp.Longest)
		24. [func regexp.Match(regexp.b []byte) bool](#Test.regexp.Match)
		25. [func regexp.MatchReader(regexp.r io.RuneReader) bool](#Test.regexp.MatchReader)
		26. [func regexp.MatchString(regexp.s string) bool](#Test.regexp.MatchString)
		27. [func regexp.NumSubexp() int](#Test.regexp.NumSubexp)
		28. [func regexp.ReplaceAll(regexp.src []byte, regexp.repl []byte) []byte](#Test.regexp.ReplaceAll)
		29. [func regexp.ReplaceAllFunc(regexp.src []byte, regexp.repl []byte []byte) []byte](#Test.regexp.ReplaceAllFunc)
		30. [func regexp.ReplaceAllLiteral(regexp.src []byte, regexp.repl []byte) []byte](#Test.regexp.ReplaceAllLiteral)
		31. [func regexp.ReplaceAllLiteralString(regexp.src string, regexp.repl string) string](#Test.regexp.ReplaceAllLiteralString)
		32. [func regexp.ReplaceAllString(regexp.src string, regexp.repl string) string](#Test.regexp.ReplaceAllString)
		33. [func regexp.ReplaceAllStringFunc(regexp.src string, regexp.repl string string) string](#Test.regexp.ReplaceAllStringFunc)
		34. [func regexp.Split(regexp.s string, regexp.n int) []string](#Test.regexp.Split)
		35. [func regexp.String() string](#Test.regexp.String)
		36. [func regexp.SubexpNames() []string](#Test.regexp.SubexpNames)
		37. [func TestConfidence() nice.Confidence](#Test.TestConfidence)
		38. [func TestDescription() string](#Test.TestDescription)
		39. [func TestName() string](#Test.TestName)
		40. [func TestSeverity() nice.Severity](#Test.TestSeverity)
	5. [var TestBulldozingError Test](#TestBulldozingError)
	6. [func TestByShortName(shortName string) (t Test, err error)](#TestByShortName)
	7. [type TestConfig](#TestConfig)
		1. [func ConfidenceRange(min nice.Confidence, max nice.Confidence) (filtered Tests)](#TestConfig.ConfidenceRange)
		2. [func progress.Go()](#TestConfig.progress.Go)
		3. [func progress.NewChild() *progress.Tracker](#TestConfig.progress.NewChild)
		4. [func SeverityRange(min nice.Severity, max nice.Severity) (filtered Tests)](#TestConfig.SeverityRange)
		5. [func progress.String() string](#TestConfig.progress.String)
		6. [func progress.Subscribe() chan ->progress.Status](#TestConfig.progress.Subscribe)
		7. [func progress.Track(progress.s progress.Status)](#TestConfig.progress.Track)
	8. [var TestHardCodedCredentials Test](#TestHardCodedCredentials)
	9. [var TestInsecureCryptography Test](#TestInsecureCryptography)
	10. [var TestSQLConcatenation Test](#TestSQLConcatenation)
	11. [func TestShortNames() (shortNames []string)](#TestShortNames)
	12. [var TestUnlimitedRead Test](#TestUnlimitedRead)
	13. [var TestUnsafeTemplateUsage Test](#TestUnsafeTemplateUsage)
	14. [type Tests](#Tests)
		1. [func ConfidenceRange(min nice.Confidence, max nice.Confidence) (filtered Tests)](#Tests.ConfidenceRange)
		2. [func NiceTest(p *nice.Program) (findings nice.Findings, err error)](#Tests.NiceTest)
		3. [func SeverityRange(min nice.Severity, max nice.Severity) (filtered Tests)](#Tests.SeverityRange)
3. [Imports](#imports)


## Doc


### <a name="CombineRegex"></a>  [func](naiive.go#L47) **[CombineRegex](#CombineRegex)**(prefix [string](//godoc.org/builtin#string), r []\*[regexp.Regexp](//godoc.org/regexp#Regexp)) (combined \*[regexp.Regexp](//godoc.org/regexp#Regexp), err [error](//godoc.org/builtin#error))



### <a name="DefaultTests"></a>  [var](defaultTests.go#L161) [DefaultTests](#DefaultTests) [Tests](#Tests)
> [][Test](#Test)




### <a name="ErrNoSuchTest"></a>  [type](defaultTests.go#L20) [ErrNoSuchTest](#ErrNoSuchTest)
#### <a name="ErrNoSuchTest.Error"></a> [func](defaultTests.go#L22) **Error**() [string](//godoc.org/builtin#string)
> [string](//godoc.org/builtin#string)




### <a name="Test"></a>  [type](naiive.go#L20) [Test](#Test)
#### <a name="Test.regexp.Copy"></a> [func](//golang.org/src/regexp/regexp.go#L114) **regexp.Copy**() \*[regexp.Regexp](//godoc.org/regexp#Regexp)
#### <a name="Test.regexp.Expand"></a> [func](//golang.org/src/regexp/regexp.go#L828) **regexp.Expand**(regexp.dst [][byte](//godoc.org/builtin#byte), regexp.template [][byte](//godoc.org/builtin#byte), regexp.src [][byte](//godoc.org/builtin#byte), regexp.match [][int](//godoc.org/builtin#int)) [][byte](//godoc.org/builtin#byte)
#### <a name="Test.regexp.ExpandString"></a> [func](//golang.org/src/regexp/regexp.go#L835) **regexp.ExpandString**(regexp.dst [][byte](//godoc.org/builtin#byte), regexp.template [string](//godoc.org/builtin#string), regexp.src [string](//godoc.org/builtin#string), regexp.match [][int](//godoc.org/builtin#int)) [][byte](//godoc.org/builtin#byte)
#### <a name="Test.regexp.Find"></a> [func](//golang.org/src/regexp/regexp.go#L731) **regexp.Find**(regexp.b [][byte](//godoc.org/builtin#byte)) [][byte](//godoc.org/builtin#byte)
#### <a name="Test.regexp.FindAll"></a> [func](//golang.org/src/regexp/regexp.go#L992) **regexp.FindAll**(regexp.b [][byte](//godoc.org/builtin#byte), regexp.n [int](//godoc.org/builtin#int)) [][][byte](//godoc.org/builtin#byte)
#### <a name="Test.regexp.FindAllIndex"></a> [func](//golang.org/src/regexp/regexp.go#L1010) **regexp.FindAllIndex**(regexp.b [][byte](//godoc.org/builtin#byte), regexp.n [int](//godoc.org/builtin#int)) [][][int](//godoc.org/builtin#int)
#### <a name="Test.regexp.FindAllString"></a> [func](//golang.org/src/regexp/regexp.go#L1028) **regexp.FindAllString**(regexp.s [string](//godoc.org/builtin#string), regexp.n [int](//godoc.org/builtin#int)) [][string](//godoc.org/builtin#string)
#### <a name="Test.regexp.FindAllStringIndex"></a> [func](//golang.org/src/regexp/regexp.go#L1046) **regexp.FindAllStringIndex**(regexp.s [string](//godoc.org/builtin#string), regexp.n [int](//godoc.org/builtin#int)) [][][int](//godoc.org/builtin#int)
#### <a name="Test.regexp.FindAllStringSubmatch"></a> [func](//golang.org/src/regexp/regexp.go#L1106) **regexp.FindAllStringSubmatch**(regexp.s [string](//godoc.org/builtin#string), regexp.n [int](//godoc.org/builtin#int)) [][][string](//godoc.org/builtin#string)
#### <a name="Test.regexp.FindAllStringSubmatchIndex"></a> [func](//golang.org/src/regexp/regexp.go#L1131) **regexp.FindAllStringSubmatchIndex**(regexp.s [string](//godoc.org/builtin#string), regexp.n [int](//godoc.org/builtin#int)) [][][int](//godoc.org/builtin#int)
#### <a name="Test.regexp.FindAllSubmatch"></a> [func](//golang.org/src/regexp/regexp.go#L1064) **regexp.FindAllSubmatch**(regexp.b [][byte](//godoc.org/builtin#byte), regexp.n [int](//godoc.org/builtin#int)) [][][][byte](//godoc.org/builtin#byte)
#### <a name="Test.regexp.FindAllSubmatchIndex"></a> [func](//golang.org/src/regexp/regexp.go#L1088) **regexp.FindAllSubmatchIndex**(regexp.b [][byte](//godoc.org/builtin#byte), regexp.n [int](//godoc.org/builtin#int)) [][][int](//godoc.org/builtin#int)
#### <a name="Test.regexp.FindIndex"></a> [func](//golang.org/src/regexp/regexp.go#L744) **regexp.FindIndex**(regexp.b [][byte](//godoc.org/builtin#byte)) (regexp.loc [][int](//godoc.org/builtin#int))
#### <a name="Test.regexp.FindReaderIndex"></a> [func](//golang.org/src/regexp/regexp.go#L783) **regexp.FindReaderIndex**(regexp.r [io.RuneReader](//godoc.org/io#RuneReader)) (regexp.loc [][int](//godoc.org/builtin#int))
#### <a name="Test.regexp.FindReaderSubmatchIndex"></a> [func](//golang.org/src/regexp/regexp.go#L982) **regexp.FindReaderSubmatchIndex**(regexp.r [io.RuneReader](//godoc.org/io#RuneReader)) [][int](//godoc.org/builtin#int)
#### <a name="Test.regexp.FindString"></a> [func](//golang.org/src/regexp/regexp.go#L757) **regexp.FindString**(regexp.s [string](//godoc.org/builtin#string)) [string](//godoc.org/builtin#string)
#### <a name="Test.regexp.FindStringIndex"></a> [func](//golang.org/src/regexp/regexp.go#L770) **regexp.FindStringIndex**(regexp.s [string](//godoc.org/builtin#string)) (regexp.loc [][int](//godoc.org/builtin#int))
#### <a name="Test.regexp.FindStringSubmatch"></a> [func](//golang.org/src/regexp/regexp.go#L953) **regexp.FindStringSubmatch**(regexp.s [string](//godoc.org/builtin#string)) [][string](//godoc.org/builtin#string)
#### <a name="Test.regexp.FindStringSubmatchIndex"></a> [func](//golang.org/src/regexp/regexp.go#L973) **regexp.FindStringSubmatchIndex**(regexp.s [string](//godoc.org/builtin#string)) [][int](//godoc.org/builtin#int)
#### <a name="Test.regexp.FindSubmatch"></a> [func](//golang.org/src/regexp/regexp.go#L796) **regexp.FindSubmatch**(regexp.b [][byte](//godoc.org/builtin#byte)) [][][byte](//godoc.org/builtin#byte)
#### <a name="Test.regexp.FindSubmatchIndex"></a> [func](//golang.org/src/regexp/regexp.go#L944) **regexp.FindSubmatchIndex**(regexp.b [][byte](//godoc.org/builtin#byte)) [][int](//godoc.org/builtin#int)
#### <a name="Test.regexp.LiteralPrefix"></a> [func](//golang.org/src/regexp/regexp.go#L428) **regexp.LiteralPrefix**() (regexp.prefix [string](//godoc.org/builtin#string), regexp.complete [bool](//godoc.org/builtin#bool))
#### <a name="Test.regexp.Longest"></a> [func](//golang.org/src/regexp/regexp.go#L165) **regexp.Longest**() 
#### <a name="Test.regexp.Match"></a> [func](//golang.org/src/regexp/regexp.go#L446) **regexp.Match**(regexp.b [][byte](//godoc.org/builtin#byte)) [bool](//godoc.org/builtin#bool)
#### <a name="Test.regexp.MatchReader"></a> [func](//golang.org/src/regexp/regexp.go#L434) **regexp.MatchReader**(regexp.r [io.RuneReader](//godoc.org/io#RuneReader)) [bool](//godoc.org/builtin#bool)
#### <a name="Test.regexp.MatchString"></a> [func](//golang.org/src/regexp/regexp.go#L440) **regexp.MatchString**(regexp.s [string](//godoc.org/builtin#string)) [bool](//godoc.org/builtin#bool)
#### <a name="Test.regexp.NumSubexp"></a> [func](//golang.org/src/regexp/regexp.go#L269) **regexp.NumSubexp**() [int](//godoc.org/builtin#int)
#### <a name="Test.regexp.ReplaceAll"></a> [func](//golang.org/src/regexp/regexp.go#L585) **regexp.ReplaceAll**(regexp.src [][byte](//godoc.org/builtin#byte), regexp.repl [][byte](//godoc.org/builtin#byte)) [][byte](//godoc.org/builtin#byte)
#### <a name="Test.regexp.ReplaceAllFunc"></a> [func](//golang.org/src/regexp/regexp.go#L613) **regexp.ReplaceAllFunc**(regexp.src [][byte](//godoc.org/builtin#byte), regexp.repl [][byte](//godoc.org/builtin#byte) [][byte](//godoc.org/builtin#byte)) [][byte](//godoc.org/builtin#byte)
#### <a name="Test.regexp.ReplaceAllLiteral"></a> [func](//golang.org/src/regexp/regexp.go#L603) **regexp.ReplaceAllLiteral**(regexp.src [][byte](//godoc.org/builtin#byte), regexp.repl [][byte](//godoc.org/builtin#byte)) [][byte](//godoc.org/builtin#byte)
#### <a name="Test.regexp.ReplaceAllLiteralString"></a> [func](//golang.org/src/regexp/regexp.go#L500) **regexp.ReplaceAllLiteralString**(regexp.src [string](//godoc.org/builtin#string), regexp.repl [string](//godoc.org/builtin#string)) [string](//godoc.org/builtin#string)
#### <a name="Test.regexp.ReplaceAllString"></a> [func](//golang.org/src/regexp/regexp.go#L486) **regexp.ReplaceAllString**(regexp.src [string](//godoc.org/builtin#string), regexp.repl [string](//godoc.org/builtin#string)) [string](//godoc.org/builtin#string)
#### <a name="Test.regexp.ReplaceAllStringFunc"></a> [func](//golang.org/src/regexp/regexp.go#L510) **regexp.ReplaceAllStringFunc**(regexp.src [string](//godoc.org/builtin#string), regexp.repl [string](//godoc.org/builtin#string) [string](//godoc.org/builtin#string)) [string](//godoc.org/builtin#string)
#### <a name="Test.regexp.Split"></a> [func](//golang.org/src/regexp/regexp.go#L1160) **regexp.Split**(regexp.s [string](//godoc.org/builtin#string), regexp.n [int](//godoc.org/builtin#int)) [][string](//godoc.org/builtin#string)
#### <a name="Test.regexp.String"></a> [func](//golang.org/src/regexp/regexp.go#L106) **regexp.String**() [string](//godoc.org/builtin#string)
#### <a name="Test.regexp.SubexpNames"></a> [func](//golang.org/src/regexp/regexp.go#L278) **regexp.SubexpNames**() [][string](//godoc.org/builtin#string)
#### <a name="Test.TestConfidence"></a> [func](naiive.go#L35) **TestConfidence**() [nice.Confidence](//godoc.org/code.justin.tv/tshadwell/nice#Confidence)
#### <a name="Test.TestDescription"></a> [func](naiive.go#L36) **TestDescription**() [string](//godoc.org/builtin#string)
#### <a name="Test.TestName"></a> [func](naiive.go#L34) **TestName**() [string](//godoc.org/builtin#string)
#### <a name="Test.TestSeverity"></a> [func](naiive.go#L37) **TestSeverity**() [nice.Severity](//godoc.org/code.justin.tv/tshadwell/nice#Severity)
> struct {  \*[regexp.Regexp](//godoc.org/regexp#Regexp)  Name [string](//godoc.org/builtin#string)  Confidence [nice.Confidence](//godoc.org/code.justin.tv/tshadwell/nice#Confidence)  Severity [nice.Severity](//godoc.org/code.justin.tv/tshadwell/nice#Severity)  Desc [string](//godoc.org/builtin#string)  Examples [][string](//godoc.org/builtin#string)  NonExamples [][string](//godoc.org/builtin#string)  ShortName [string](//godoc.org/builtin#string) }




### <a name="TestBulldozingError"></a>  [var](defaultTests.go#L63) [TestBulldozingError](#TestBulldozingError) [Test](#Test)
> struct {  \*[regexp.Regexp](//godoc.org/regexp#Regexp)  Name [string](//godoc.org/builtin#string)  Confidence [nice.Confidence](//godoc.org/code.justin.tv/tshadwell/nice#Confidence)  Severity [nice.Severity](//godoc.org/code.justin.tv/tshadwell/nice#Severity)  Desc [string](//godoc.org/builtin#string)  Examples [][string](//godoc.org/builtin#string)  NonExamples [][string](//godoc.org/builtin#string)  ShortName [string](//godoc.org/builtin#string) }




### <a name="TestByShortName"></a>  [func](defaultTests.go#L24) **[TestByShortName](#TestByShortName)**(shortName [string](//godoc.org/builtin#string)) (t [Test](#Test), err [error](//godoc.org/builtin#error))



### <a name="TestConfig"></a>  [type](naiive.go#L39) [TestConfig](#TestConfig)
#### <a name="TestConfig.ConfidenceRange"></a> [func](naiive.go#L231) **ConfidenceRange**(min [nice.Confidence](//godoc.org/code.justin.tv/tshadwell/nice#Confidence), max [nice.Confidence](//godoc.org/code.justin.tv/tshadwell/nice#Confidence)) (filtered [Tests](#Tests))
#### <a name="TestConfig.progress.Go"></a> [func](../progress/progress.go#L80) **progress.Go**() 
#### <a name="TestConfig.progress.NewChild"></a> [func](../progress/progress.go#L148) **progress.NewChild**() \*[progress.Tracker](//godoc.org/code.justin.tv/tshadwell/nice/progress#Tracker)
#### <a name="TestConfig.SeverityRange"></a> [func](naiive.go#L241) **SeverityRange**(min [nice.Severity](//godoc.org/code.justin.tv/tshadwell/nice#Severity), max [nice.Severity](//godoc.org/code.justin.tv/tshadwell/nice#Severity)) (filtered [Tests](#Tests))
#### <a name="TestConfig.progress.String"></a> [func](../progress/progress.go#L58) **progress.String**() [string](//godoc.org/builtin#string)
#### <a name="TestConfig.progress.Subscribe"></a> [func](../progress/progress.go#L60) **progress.Subscribe**() chan ->[progress.Status](//godoc.org/code.justin.tv/tshadwell/nice/progress#Status)
#### <a name="TestConfig.progress.Track"></a> [func](../progress/progress.go#L68) **progress.Track**(progress.s [progress.Status](//godoc.org/code.justin.tv/tshadwell/nice/progress#Status)) 
> struct {  IncludeStdLib [bool](//godoc.org/builtin#bool)  CombinedRegex \*[regexp.Regexp](//godoc.org/regexp#Regexp)  [Tests](#Tests)  \*[progress.Tracker](//godoc.org/code.justin.tv/tshadwell/nice/progress#Tracker) }




### <a name="TestHardCodedCredentials"></a>  [var](defaultTests.go#L123) [TestHardCodedCredentials](#TestHardCodedCredentials) [Test](#Test)
> struct {  \*[regexp.Regexp](//godoc.org/regexp#Regexp)  Name [string](//godoc.org/builtin#string)  Confidence [nice.Confidence](//godoc.org/code.justin.tv/tshadwell/nice#Confidence)  Severity [nice.Severity](//godoc.org/code.justin.tv/tshadwell/nice#Severity)  Desc [string](//godoc.org/builtin#string)  Examples [][string](//godoc.org/builtin#string)  NonExamples [][string](//godoc.org/builtin#string)  ShortName [string](//godoc.org/builtin#string) }




### <a name="TestInsecureCryptography"></a>  [var](defaultTests.go#L137) [TestInsecureCryptography](#TestInsecureCryptography) [Test](#Test)
> struct {  \*[regexp.Regexp](//godoc.org/regexp#Regexp)  Name [string](//godoc.org/builtin#string)  Confidence [nice.Confidence](//godoc.org/code.justin.tv/tshadwell/nice#Confidence)  Severity [nice.Severity](//godoc.org/code.justin.tv/tshadwell/nice#Severity)  Desc [string](//godoc.org/builtin#string)  Examples [][string](//godoc.org/builtin#string)  NonExamples [][string](//godoc.org/builtin#string)  ShortName [string](//godoc.org/builtin#string) }




### <a name="TestSQLConcatenation"></a>  [var](defaultTests.go#L149) [TestSQLConcatenation](#TestSQLConcatenation) [Test](#Test)
> struct {  \*[regexp.Regexp](//godoc.org/regexp#Regexp)  Name [string](//godoc.org/builtin#string)  Confidence [nice.Confidence](//godoc.org/code.justin.tv/tshadwell/nice#Confidence)  Severity [nice.Severity](//godoc.org/code.justin.tv/tshadwell/nice#Severity)  Desc [string](//godoc.org/builtin#string)  Examples [][string](//godoc.org/builtin#string)  NonExamples [][string](//godoc.org/builtin#string)  ShortName [string](//godoc.org/builtin#string) }




### <a name="TestShortNames"></a>  [func](defaultTests.go#L12) **[TestShortNames](#TestShortNames)**() (shortNames [][string](//godoc.org/builtin#string))



### <a name="TestUnlimitedRead"></a>  [var](defaultTests.go#L40) [TestUnlimitedRead](#TestUnlimitedRead) [Test](#Test)
> struct {  \*[regexp.Regexp](//godoc.org/regexp#Regexp)  Name [string](//godoc.org/builtin#string)  Confidence [nice.Confidence](//godoc.org/code.justin.tv/tshadwell/nice#Confidence)  Severity [nice.Severity](//godoc.org/code.justin.tv/tshadwell/nice#Severity)  Desc [string](//godoc.org/builtin#string)  Examples [][string](//godoc.org/builtin#string)  NonExamples [][string](//godoc.org/builtin#string)  ShortName [string](//godoc.org/builtin#string) }




### <a name="TestUnsafeTemplateUsage"></a>  [var](defaultTests.go#L83) [TestUnsafeTemplateUsage](#TestUnsafeTemplateUsage) [Test](#Test)
> struct {  \*[regexp.Regexp](//godoc.org/regexp#Regexp)  Name [string](//godoc.org/builtin#string)  Confidence [nice.Confidence](//godoc.org/code.justin.tv/tshadwell/nice#Confidence)  Severity [nice.Severity](//godoc.org/code.justin.tv/tshadwell/nice#Severity)  Desc [string](//godoc.org/builtin#string)  Examples [][string](//godoc.org/builtin#string)  NonExamples [][string](//godoc.org/builtin#string)  ShortName [string](//godoc.org/builtin#string) }




### <a name="Tests"></a>  [type](naiive.go#L229) [Tests](#Tests)
#### <a name="Tests.ConfidenceRange"></a> [func](naiive.go#L231) **ConfidenceRange**(min [nice.Confidence](//godoc.org/code.justin.tv/tshadwell/nice#Confidence), max [nice.Confidence](//godoc.org/code.justin.tv/tshadwell/nice#Confidence)) (filtered [Tests](#Tests))
#### <a name="Tests.NiceTest"></a> [func](naiive.go#L251) **NiceTest**(p \*[nice.Program](//godoc.org/code.justin.tv/tshadwell/nice#Program)) (findings [nice.Findings](//godoc.org/code.justin.tv/tshadwell/nice#Findings), err [error](//godoc.org/builtin#error))
#### <a name="Tests.SeverityRange"></a> [func](naiive.go#L241) **SeverityRange**(min [nice.Severity](//godoc.org/code.justin.tv/tshadwell/nice#Severity), max [nice.Severity](//godoc.org/code.justin.tv/tshadwell/nice#Severity)) (filtered [Tests](#Tests))
> [][Test](#Test)



## Imports
[fmt](//godoc.org/fmt)
[regexp](//godoc.org/regexp)
[code.justin.tv/tshadwell/nice](//godoc.org/code.justin.tv/tshadwell/nice)
[go/token](//godoc.org/go/token)
[io/ioutil](//godoc.org/io/ioutil)
[os](//godoc.org/os)
[path/filepath](//godoc.org/path/filepath)
[runtime](//godoc.org/runtime)
[strings](//godoc.org/strings)
[sync](//godoc.org/sync)
[code.justin.tv/tshadwell/nice/progress](//godoc.org/code.justin.tv/tshadwell/nice/progress)
[github.com/golang/glog](//godoc.org/github.com/golang/glog)
