import { HostedZone, IHostedZone } from '@aws-cdk/aws-route53';
import { Construct, Stack, StackProps } from '@aws-cdk/core';

/**
 * Route 53 zones for the dev account.
 */
export class DevZonesStack extends Stack {
  public readonly internalZone: IHostedZone;

  constructor(scope: Construct, props?: StackProps) {
    super(scope, 'DevZones', props);

    this.internalZone = HostedZone.fromLookup(this, 'InternalZone', { domainName: 'dev.metadata.twitch.a2z.com' });
  }
}
