import { DnsValidatedCertificate, ICertificate } from '@aws-cdk/aws-certificatemanager';
import { IHostedZone } from '@aws-cdk/aws-route53';
import { Construct, Stack, StackProps } from '@aws-cdk/core';

interface IngestServiceRepoStackProps extends StackProps {
  /** The domain name to create a certificate for. */
  domainName: string;
  /** The Route 53 zone that owns the domain.  */
  hostedZone: IHostedZone;
}

/**
 * ACM certificate for the Ingest Service.
 */
export class IngestCertsStack extends Stack {
  public readonly primary: ICertificate;

  constructor(scope: Construct, name: string, props: IngestServiceRepoStackProps) {
    super(scope, name, props);

    this.primary = new DnsValidatedCertificate(this, 'Certficate', {
      domainName: props.domainName,
      hostedZone: props.hostedZone,
    });
  }
}
