import { IRepository, Repository } from '@aws-cdk/aws-ecr';
import { Construct, RemovalPolicy, Stack, StackProps, Tag } from '@aws-cdk/core';

/**
 * ECR repositories for the Ingest Service.
 *
 * Must be created and seeded with a "latest" container before the service stack is created.
 */
export class IngestReposStack extends Stack {
  public readonly primary: IRepository;

  constructor(scope: Construct, name: string, props: StackProps) {
    super(scope, name, props);

    const primaryRepo = new Repository(this, 'Repository', {
      removalPolicy: RemovalPolicy.DESTROY,
    });
    primaryRepo.addLifecycleRule({ maxImageCount: 10 });
    Tag.add(primaryRepo, 'DeployRepo', 'Ingest');

    this.primary = primaryRepo;
  }
}
