import { ISecret, Secret } from '@aws-cdk/aws-secretsmanager';
import { Construct, Stack, StackProps } from '@aws-cdk/core';

/**
 * Contains secrets specific to the Ingest Service
 */
export class IngestSecretsStack extends Stack {
  public readonly primary: ISecret;

  constructor(scope: Construct, name: string, props: StackProps) {
    super(scope, name, props);

    this.primary = new Secret(this, 'PrimarySecret');
  }
}
