import { HostedZone, IHostedZone, TxtRecord } from '@aws-cdk/aws-route53';
import { Construct, Stack, StackProps } from '@aws-cdk/core';

/**
 * Route 53 zones for the prod account.
 */
export class ProdZonesStack extends Stack {
  public readonly internalZone: IHostedZone;
  public readonly publicZone: IHostedZone;

  constructor(scope: Construct, props?: StackProps) {
    super(scope, 'ProdZones', props);

    this.internalZone = HostedZone.fromLookup(this, 'InternalZone', {
      domainName: 'prod.metadata.twitch.a2z.com',
    });

    this.publicZone = HostedZone.fromLookup(this, 'MetadataPublicZone', { domainName: 'metadata.twitch.tv' });

    const newPublicZone = new HostedZone(this, 'E2PublicZone', {
      zoneName: 'e2.twitch.tv',
      comment: 'Enhanced Experiences (public)',
    });

    new TxtRecord(this, 'E2PublicZoneTestRecord', {
      zone: newPublicZone,
      recordName: '_test.e2.twitch.tv',
      values: ['Enhanced Experiences (public)'],
    });
  }
}
