// TagsValidatorBucketsStack
import { Bucket } from '@aws-cdk/aws-s3';
import { Construct, Stack, StackProps, Tag } from '@aws-cdk/core';

/**
 * Creates S3 bucket for the Tag Validator.
 */
export class TagsValidatorBucketsStack extends Stack {
  public readonly bucket: Bucket;

  constructor(scope: Construct, name: string, props: StackProps) {
    super(scope, name, props);

    this.bucket = new Bucket(this, 'Bucket');

    Tag.add(this.bucket, 'DeployBucket', 'TagsValidator');
  }
}
