import { IVpc, Vpc } from '@aws-cdk/aws-ec2';
import { Construct, Stack, StackProps } from '@aws-cdk/core';

interface VpcStackProps extends StackProps {
  vpcId: string;
}

/**
 * VPC for the dev account.
 */
export class VpcStack extends Stack {
  public readonly vpc: IVpc;

  constructor(scope: Construct, name: string, props: VpcStackProps) {
    super(scope, name, props);

    this.vpc = Vpc.fromLookup(this, 'Vpc', { vpcId: props.vpcId });
  }
}
