# E2 Ingest Service

Ingest service for E2. It serves to connect game server/client with us to pipe game metadata. The external edge is websocket based instead of REST APIs, which enables low latency data streaming and reduce the constantly establish handshakes when data piping frequency is high.

## Wikis

Please refer to [E2 Development Home Page](https://wiki.twitch.com/display/DS/E2+Development+Home+Page) for all your questions regarding E2 including architecture, authentication, how to onboard, usages and best practices.

## Slack

Feel free to ping #e2-mdaas channel for all your questions.

## Endpoint

- Production: [wss://metadata.twitch.tv/api/ingest](wss://metadata.twitch.tv/api/ingest)
- Staging: [wss://ingest.dev.metadata.twitch.a2z.com/api/ingest](wss://ingest.dev.metadata.twitch.a2z.com/api/ingest)
- Local: [ws://localhost:8080/api/ingest](ws://localhost:8080/api/ingest)

## Develop guide

See [Development Guide](docs/development.md)

## PR and Deployment rules

See [PR and Deployment Guidelines](docs/pr-deploy.md) for more details.

## E2E tests

See [E2E Test Documentation](docs/e2e.md)

## Infrastructure and tools

- Logs will be stored using Cloudwatch.
- Metrics will be published via Cloudwatch.
- AWS Secret Manager is used to store credentials.
- Rollbar is used for error traces.
- Infra is built with CDK and using [AWS fargate](https://aws.amazon.com/fargate/).

Please refer to [MDaaS-Infra](https://git.xarth.tv/devhub/mdaas-infra)

## Dashboards

- [MDaaS Overview Dashboard](https://isengard.amazon.com/federate?account=433343386846&role=admin&destination=%2Fcloudwatch%2Fhome%3Fregion%3Dus-west-2%23dashboards%3Aname%3DMDaaS-Overview)
- [Discovery dashboard for auto-tag feature](https://grafana.xarth.tv/d/000001156/discovery-graffiti?orgId=1&from=now-12h&to=now&panelId=176&fullscreen&edit&var-environment=canary-production&var-environment=production&var-endpoint=GetBulkContentTags&var-redis_op=All&var-service=Graffiti)

## OnCall Runbook

- [docs/runbook.md](./docs/runbook.md)
- [More resources](https://wiki.twitch.com/display/DS/E2+Oncall+Resources)
