package main

import (
	"flag"
	"fmt"
	"os"
	"reflect"

	"github.com/fatih/color"

	. "code.justin.tv/devhub/mdaas-ingest/cmd/e2e_utils"
)

var skippedTests []string

// Exclude the flaky tests which takes long time or only support singleton run
func init() {
	skippedTests = []string{"TestIdleConnection", "TestServiceGracefullyShutdown"}
}

func main() {
	token := os.Getenv("TEST_TOKEN")
	userToken := os.Getenv("USER_TOKEN")
	testName := flag.String("name", "", "the test id to run")
	env := flag.String("env", "docker", "the environment e2e test will be running against")
	kinesis := flag.Bool("kinesis", true, "if turn on kinesis test")
	gameID := flag.String("game", "21779", "game id to test against")
	// TODO:  make it a list to test multiple broadcaster case
	testBroadcasterIDs := flag.String("broadcaster", "testBroadcasterID", "test broadcaster ids to send in the connection")

	flag.Parse()

	tester := NewTestImpl(token, userToken, env, kinesis, gameID, testBroadcasterIDs)

	funcs := map[string]interface{}{
		"TestHappyPath":                                tester.TestHappyPath,
		"TestNotAuthedConnectPack":                     tester.TestNotAuthedConnectPack,
		"TestSendDeltaTooFastExceedLimit":              tester.TestSendDeltaTooFastExceedLimit,
		"TestIdleConnection":                           tester.TestIdleConnection,
		"TestBadDeltaPack":                             tester.TestBadDeltaPack,
		"TestHappyPathSendingDataEverySecond":          tester.TestHappyPathSendingDataEverySecond,
		"TestRespondToErrorWithRefreshNewState":        tester.TestRespondToErrorWithRefreshNewState,
		"TestCloseConnectionWhileListeningFlushResp":   tester.TestCloseConnectionWhileListeningFlushResp,
		"TestSimulatingWholeFlow":                      tester.TestSimulatingWholeFlow,
		"TestHappyPathWithFullReplacePlusDelta":        tester.TestHappyPathWithFullReplacePlusDelta,
		"TestHeathCheck":                               tester.TestHeathCheck,
		"TestKeepSendingBadDeltaPack":                  tester.TestKeepSendingBadDeltaPack,
		"TestBadMessage":                               tester.TestBadMessage,
		"TestSpecificGame":                             tester.TestSpecificGame,
		"TestServiceGracefullyShutdown":                tester.TestServiceGracefullyShutdown,
		"TestKinesisHappyPath":                         tester.TestKinesisHappyPath,
		"TestKinesisLongConnection":                    tester.TestKinesisLongConnection,
		"TestKinesisWithBadDelta":                      tester.TestKinesisWithBadDelta,
		"TestKinesisWithRefresh":                       tester.TestKinesisWithRefresh,
		"TestKinesisWithFlush":                         tester.TestKinesisWithFlush,
		"TestKinesisHappyPathUserToken":                tester.TestKinesisHappyPathUserToken,
		"TestKinesisLongConnectionUserToken":           tester.TestKinesisLongConnectionUserToken,
		"TestNotAuthedAppTokenPublishUnauthorizedUser": tester.TestNotAuthedAppTokenPublishUnauthorizedUser,
		"TestTagsValidatorNormalPath":                  tester.TestTagsValidatorNormalPath,
		"TestTagsValidatorNormalPathUnwhitelistedTags": tester.TestTagsValidatorNormalPathUnwhitelistedTags,
		"TestSNSPublishNormalPath":                     tester.TestSNSPublishNormalPath,
	}

	if testName != nil && *testName != "" {
		runFuncsByName(funcs, *testName)
	} else {

		// If not specifying any tests, run all tests
		var allTests []string
		for k := range funcs {
			if !ifSkippedTest(k) {
				allTests = append(allTests, k)
			}
		}

		for _, test := range allTests {
			runFuncsByName(funcs, test)
		}
	}

	fmt.Println("=========================================")
	fmt.Println("Leaving integration test.")
}

func ifSkippedTest(currentTest string) bool {
	for _, test := range skippedTests {
		if test == currentTest {
			return true
		}
	}
	return false
}

func runFuncsByName(funcs map[string]interface{}, name string) {
	color.Blue("=========================================")
	color.Blue("Running %s...\n", name)

	f := reflect.ValueOf(funcs[name])
	f.Call([]reflect.Value{})
}
