#!/bin/bash
# clean up
cleanUp() {
    echo "==> clean up"
    docker-compose down -v
}
# check if env variable E2E_TEST_USER_CLIENT_SECRET is set when running on local
if [[ -z "${E2E_TEST_USER_CLIENT_SECRET}" ]]; then
    echo "==> retriving e2e test user client secret from secret manager"
    export E2E_TEST_USER_CLIENT_SECRET=$(aws secretsmanager get-secret-value --secret-id E2ETestUserClientSecret | jq -r '.SecretString | fromjson | .secret')
fi
echo "==> spinning up e2e_service"
docker-compose up -d e2e_service
echo "==> waiting for e2e_service to be ready..."
docker-compose logs -f e2e_service | grep -q "listening for sandstorm updates"
echo "==> e2e_service is ready, spinning up e2e test client"
docker-compose run --rm e2e_test
e2eTestExitCode=$?
cleanUp
exit $e2eTestExitCode
