package e2e_utils

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"code.justin.tv/devhub/mdaas-ingest/models"

	"golang.org/x/net/websocket"
)

func (tester *eceImpl) TestBadDeltaPack() {
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData)

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestBadDeltaPack", ws)

	spinUpValidationWorker(validateBadDeltaPack, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	// Wait 1 seconds to send delta pack
	time.Sleep(1 * time.Second)

	// Send delta pack
	var deltaData1 map[string]interface{}
	_ = json.Unmarshal([]byte(BadDeltaPack), &deltaData1)
	err = websocket.JSON.Send(ws, deltaData1)
	if err != nil {
		fmt.Println("Error sending delta ops message: ", err.Error())
	}

	// Wait 3 seconds
	time.Sleep(3 * time.Second)
}

func (tester *eceImpl) TestKeepSendingBadDeltaPack() {
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData)

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestKeepSendingBadDeltaPack", ws)

	spinUpValidationWorker(validateBadDeltaPack, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	for i := 0; i < 5; i++ {
		// Wait 1 seconds to send delta pack
		time.Sleep(1 * time.Second)

		// Send delta pack
		var deltaData1 map[string]interface{}
		_ = json.Unmarshal([]byte(BadDeltaPack), &deltaData1)
		err = websocket.JSON.Send(ws, deltaData1)
		if err != nil {
			fmt.Println("Error sending delta ops message: ", err.Error())
		}
	}

	// Wait 3 seconds
	time.Sleep(3 * time.Second)
}

func validateBadDeltaPack(count int, result map[string]interface{}) {
	switch count {
	case 1:
		validateConnectPack(result)
	case 2:
		validateResp(result, models.DeltaInvalid, "delta invalid message")
	case 3, 4, 5, 6:
		validateResp(result, models.WaitingOnRefreshPack, "wait on refresh pack")
	default:
		encounterUnexpectedResp(result)
	}
}
