package e2e_utils

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"code.justin.tv/devhub/mdaas-ingest/models"

	"golang.org/x/net/websocket"
)

func (tester *eceImpl) TestBadMessage() {
	connectPack := `{"connect": {"token":"garbage","game_id": 56,"data": {"key": "blob","secondkey":"secondblob"}}}`

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestBadMessage", ws)

	spinUpValidationWorker(validateBadMessage, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	// Wait 3 seconds
	time.Sleep(3 * time.Second)
}

func validateBadMessage(count int, result map[string]interface{}) {
	fmt.Println("Received ", result)
	switch count {
	case 1:
		validateResp(result, models.BadDataPack, "invalid message")
	default:
		encounterUnexpectedResp(result)
	}
}
