package e2e_utils

var sessionID = "testSessionID"

var TagUUIDsGearBox = map[string]string{
	"Amara":  "f9029b6f-a894-482d-a77a-84598859b2a3", // Vault Hunter: Amara
	"FL4K":   "d902fd55-1c9d-40ff-bbda-2efe8608f487", // Vault Hunter: FL4K
	"Moze":   "e2fc3838-3c58-44db-8b1c-b5d058acf479", // Vault Hunter: Moze
	"Zane":   "060fbf32-f5b9-4262-8071-3fba1307fa36", // Vault Hunter: Zane
	"Hunter": "a0bbbfd5-a59e-4005-8bcb-22e9c932a15b", // Mode: True Vault Hunter
	"Mayhem": "4381920b-dd0c-4696-aad3-41f49202ff57", // Mode: Mayhem
}

var StandardConnectionData = `{
	"connect": {
		"token": "testToken",
		"broadcaster_ids": [
			"testBroadcasterID"
		],
		"session_id": "testSessionID",
		"game_id": "21779",
		"env": "dev",
		"data": {
			"_metadata": {
				"tags": ["` + TagUUIDsGearBox["Amara"] + `","` + TagUUIDsGearBox["FL4K"] + `"]

			},
			"damage_dealt": 12092,
			"position": [
				[1, 2],
				[3, 4]
			],
			"champion": {
				"name": "lulu",
				"resource": [1, 2, 3, 4],
				"skill": {
					"q": 1,
					"w": 3
				}
			}
		}
	}
}`

var StandardUserConnectionData = `{
	"connect": {
		"token": "testToken",
		"session_id": "testSessionID",
		"game_id": "21779",
		"env": "dev",
		"data": {
			"_metadata": {
				"tags": ["` + TagUUIDsGearBox["Amara"] + `","` + TagUUIDsGearBox["FL4K"] + `"]

			},
			"damage_dealt": 12092,
			"position": [
				[1, 2],
				[3, 4]
			],
			"champion": {
				"name": "lulu",
				"resource": [1, 2, 3, 4],
				"skill": {
					"q": 1,
					"w": 3
				}
			}
		}
	}
}`

// Change damage_dealt to an array to correspond to "bad delta" format
var StandardRefresh = `{
	"refresh": {
		"data": {
			"_metadata": {
				"tags": ["` + TagUUIDsGearBox["Moze"] + `"]

			},
			"damage_dealt": [12092],
			"position": [
				[1, 2],
				[3, 4]
			],
			"champion": {
				"name": "lulu",
				"resource": [1, 2, 3, 4],
				"skill": {
					"q": 1,
					"w": 3
				}
			}
		}
	}
}`

var StandardDeltaPackWithDeltaOps = `{"delta":[["damage_dealt", 10000], ["champion.skill.e", 2]]}`

var StandardDeltaPackWithFullReplace = `{
	"delta": [
		[{
			"_metadata": {
				"tags": ["` + TagUUIDsGearBox["Amara"] + `","` + TagUUIDsGearBox["FL4K"] + `"]

			},
			"damage_dealt": 12092,
			"position": [
				[1, 2],
				[3, 4]
			],
			"champion": {
				"name": "lulu",
				"resource": [1, 2, 3, 4],
				"skill": {
					"q": 1,
					"w": 3
				}
			}
		}],
		["damage_dealt", 10001],
		["champion.skill.e", 4]
	]
}`

// Damage dealt is not an array
var BadDeltaPack = `{"delta":[["damage_dealt[0]", 10000], ["champion.skill.e", 2]]}`
var StandardDeltaPackChangeMetadata = `{"delta":[["_metadata.tags",["` + TagUUIDsGearBox["Amara"] + `"]]]}`
var StandardFlushPack = `{"flush":"09DSLKJ392"}`
