package e2e_utils

import (
	"fmt"
	"math/rand"
	"time"

	"github.com/davecgh/go-spew/spew"
	"golang.org/x/net/websocket"
)

const (
	stagingHost = "wss://ingest.dev.metadata.twitch.a2z.com/api/ingest"
	dockerHost  = "ws://e2e_service:80/api/ingest"
	localhost   = "ws://localhost:8080/api/ingest" // Need to spin up port at 8080 for tesing purpose
	prodHost    = "wss://metadata.twitch.tv/api/ingest"
	devTagsSQS  = "https://sqs.us-west-2.amazonaws.com/797743463538/tagsDev"
	//prodTagsSQS = "https://sqs.us-west-2.amazonaws.com/433343386846/devTags"
	stagingSQS = "https://sqs.us-west-2.amazonaws.com/797743463538/e2e-test-validator"
)

// E2E tests for real life cases
type E2E interface {
	TestHappyPath()
	TestNotAuthedConnectPack()
	TestSendDeltaTooFastExceedLimit()
	TestIdleConnection()
	TestBadDeltaPack()
	TestHappyPathSendingDataEverySecond()
	TestRespondToErrorWithRefreshNewState()
	TestCloseConnectionWhileListeningFlushResp()
	TestSimulatingWholeFlow()
	TestHappyPathWithFullReplacePlusDelta()
	TestHeathCheck()
	TestKeepSendingBadDeltaPack()
	TestBadMessage()
	TestSpecificGame()
	TestServiceGracefullyShutdown()
	TestKinesisHappyPath()
	TestKinesisLongConnection()
	TestKinesisWithBadDelta()
	TestKinesisWithRefresh()
	TestKinesisWithFlush()
	TestKinesisHappyPathUserToken()
	TestKinesisLongConnectionUserToken()
	TestNotAuthedAppTokenPublishUnauthorizedUser()
	TestTagsValidatorNormalPath()
	TestTagsValidatorNormalPathUnwhitelistedTags()
	TestSNSPublishNormalPath()
}

type eceImpl struct {
	Env            *string
	UserToken      string
	Token          string
	Kinesis        bool
	GameID         string
	BroadcasterIDs string
}

func NewTestImpl(token string, userToken string, env *string, kinesis *bool, gameID, testBroadcasterIDs *string) E2E {
	kinesisStatus := false
	if kinesis != nil {
		kinesisStatus = *kinesis
	}

	id := "21779"
	if gameID != nil {
		id = *gameID
	}

	return &eceImpl{Token: token, UserToken: userToken, Env: env, Kinesis: kinesisStatus, GameID: id, BroadcasterIDs: *testBroadcasterIDs}
}

func (tester *eceImpl) connect() (*websocket.Conn, error) {
	host := dockerHost
	if tester.Env != nil {
		if *tester.Env == "local" {
			host = localhost
		} else if *tester.Env == "staging" {
			host = stagingHost
		} else if *tester.Env == "prod" {
			host = prodHost
		}
	}
	return websocket.Dial(host, "", mockedIP())
}

func mockedIP() string {
	var arr [4]int
	for i := 0; i < 4; i++ {
		rand.Seed(time.Now().UnixNano())
		arr[i] = rand.Intn(256)
	}
	return fmt.Sprintf("http://%d.%d.%d.%d", arr[0], arr[1], arr[2], arr[3])
}

func spinUpReceiveWorker(ws *websocket.Conn) {
	// receive
	go func() {
		for {
			var m map[string]interface{}
			err := websocket.JSON.Receive(ws, &m)
			if err != nil {
				fmt.Println("Error receiving message: ", err.Error())
				break
			}
			spew.Dump(m)
		}
	}()
}
