package e2e_utils

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"code.justin.tv/devhub/mdaas-ingest/models"

	"golang.org/x/net/websocket"
)

func (tester *eceImpl) TestCloseConnectionWhileListeningFlushResp() {
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData)

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestCloseConnectionWhileListeningFlushResp", ws)
	spinUpValidationWorker(validateFlushPack, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	// Wait 1 seconds to send delta pack
	time.Sleep(1 * time.Second)

	for i := 1; i < 7; i++ {
		// Wait 1 seconds to send delta pack
		time.Sleep(1 * time.Second)

		// Send delta pack
		var deltaData1 map[string]interface{}
		_ = json.Unmarshal([]byte(StandardDeltaPackWithDeltaOps), &deltaData1)
		err = websocket.JSON.Send(ws, deltaData1)
		if err != nil {
			fmt.Println("Error sending delta ops message: ", err.Error())
		}
	}

	var flushData map[string]interface{}
	_ = json.Unmarshal([]byte(StandardFlushPack), &flushData)

	// Send flush pack
	err = websocket.JSON.Send(ws, flushData)
	if err != nil {
		fmt.Println("Error sending flush message: ", err.Error())
	}

	// Wait 3 seconds
	time.Sleep(3 * time.Second)
}

func validateFlushPack(count int, result map[string]interface{}) {
	fmt.Println("Received ", result)
	switch count {
	case 1:
		validateConnectPack(result)
	case 2:
		validateResp(result, models.Flushed{Flushed: "09DSLKJ392"}, "flushed message")
	default:
		encounterUnexpectedResp(result)
	}
}
