package e2e_utils

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"golang.org/x/net/websocket"
)

// Only use to trigger a kinesis for a specific game
func (tester *eceImpl) TestSpecificGame() {
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData)
	gameSpecificPack := replaceGame(tester.GameID, connectPack)

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestSpecificGame", ws)

	spinUpValidationWorker(validateOnlyConnect, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(gameSpecificPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	// Wait 1 seconds to send delta pack
	time.Sleep(2 * time.Second)

	// Send delta pack
	var deltaData1 map[string]interface{}
	_ = json.Unmarshal([]byte(StandardDeltaPackWithDeltaOps), &deltaData1)
	err = websocket.JSON.Send(ws, deltaData1)
	if err != nil {
		fmt.Println("Error sending delta ops message: ", err.Error())
	}

	// Wait 1 seconds
	time.Sleep(1 * time.Second)
}

func replaceGame(gameID string, connectionData string) string {
	jsonMap := make(map[string]interface{})
	err := json.Unmarshal([]byte(connectionData), &jsonMap)
	if err != nil {
		panic(err)
	}

	jsonMap["connect"].(map[string]interface{})["game_id"] = gameID

	completeConnectPack, _ := json.Marshal(jsonMap)
	return string(completeConnectPack)
}
