package e2e_utils

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"golang.org/x/net/websocket"

	"code.justin.tv/devhub/mdaas-ingest/models"
)

func (tester *eceImpl) TestServiceGracefullyShutdown() {
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData) // connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestServiceGracefullyShutdown", ws)

	spinUpValidationWorker(validateReconnect, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}
	// Please shutdown your service and validate reconnect package
	time.Sleep(10 * time.Second)
}

func validateReconnect(count int, result map[string]interface{}) {
	fmt.Println("Received ", result)
	switch count {
	case 1:
		validateConnectPack(result)
	case 2:
		validateResp(result, models.ReconnectMsg{}, "reconnect message")
	default:
		encounterUnexpectedResp(result)
	}
}
