package e2e_utils

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"golang.org/x/net/websocket"
)

// Send valid connect pack and delta pack, monitor results
func (tester *eceImpl) TestHappyPath() {
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData)

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestHappyPath", ws)

	spinUpValidationWorker(validateOnlyConnect, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	// Wait 1 seconds to send delta pack
	time.Sleep(2 * time.Second)

	// Send delta pack
	var deltaData1 map[string]interface{}
	_ = json.Unmarshal([]byte(StandardDeltaPackWithDeltaOps), &deltaData1)
	err = websocket.JSON.Send(ws, deltaData1)
	if err != nil {
		fmt.Println("Error sending delta ops message: ", err.Error())
	}

	// Wait 1 seconds
	time.Sleep(1 * time.Second)
}

// Send valid connect pack and delta pack, monitor results
func (tester *eceImpl) TestHappyPathSendingDataEverySecond() {
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData)

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestHappyPathSendingDataEverySecond", ws)

	spinUpValidationWorker(validateOnlyConnect, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	for i := 1; i < 20; i++ {
		// Wait 1 seconds to send delta pack
		time.Sleep(1 * time.Second)

		// Send delta pack
		var deltaData1 map[string]interface{}
		_ = json.Unmarshal([]byte(StandardDeltaPackWithDeltaOps), &deltaData1)
		err = websocket.JSON.Send(ws, deltaData1)
		if err != nil {
			fmt.Println("Error sending delta ops message: ", err.Error())
		}
	}

	// Wait 3 seconds
	time.Sleep(3 * time.Second)
}

// Send valid connect pack and delta pack, monitor results
func (tester *eceImpl) TestHappyPathWithFullReplacePlusDelta() {
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData)

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestHappyPathWithFullReplacePlusDelta", ws)

	spinUpValidationWorker(validateOnlyConnect, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	// Wait 1 seconds to send delta pack
	time.Sleep(1 * time.Second)

	// Send delta pack
	var deltaData map[string]interface{}
	_ = json.Unmarshal([]byte(StandardDeltaPackWithFullReplace), &deltaData)
	err = websocket.JSON.Send(ws, deltaData)
	if err != nil {
		fmt.Println("Error sending delta ops message: ", err.Error())
	}

	// Wait 3 seconds
	time.Sleep(3 * time.Second)
}
