package e2e_utils

import (
	"fmt"
	. "net/http"
	"os"

	"github.com/fatih/color"
)

func (tester *eceImpl) TestHeathCheck() {

	endpoint := "http://e2e_service:80/ping"

	if tester.Env != nil {

		switch *tester.Env {
		case "local":
			endpoint = "http://localhost:8080/ping"
		case "staging":
			endpoint = "https://ingest.dev.metadata.twitch.a2z.com/ping"
		case "docker":
			endpoint = "http://e2e_service:80/ping"
		case "prod":
			endpoint = "https://metadata.twitch.tv/ping"
		default:
			endpoint = ""
		}
	}

	resp, err := Get(endpoint)

	if resp.StatusCode != 200 {
		fmt.Println(err)
		fmt.Println("Failed validation for health check endpoint.")
		os.Exit(1)
	}

	color.Green("All tests passed for TestHeathCheck")
}
