package e2e_utils

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"golang.org/x/net/websocket"
)

// Send valid connect pack and doing nothing over 10 sec, should see a disconnect bc long time no data
func (tester *eceImpl) TestIdleConnection() {
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData)

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestIdleConnection", ws)

	spinUpReceiveWorker(ws)
	spinUpValidationWorker(validateOnlyConnect, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	// Wait 13 seconds, idle worker should be disconnected
	time.Sleep(23 * time.Second)
}
