package e2e_utils

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"golang.org/x/net/websocket"
)

func (tester *eceImpl) TestKinesisHappyPath() {
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData)
	k, iterator := tester.getIterator(tester.BroadcasterIDs, "21779")

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestKinesisHappyPath", ws)

	spinUpValidationWorker(validateOnlyConnect, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	// Send delta pack
	var deltaData1 map[string]interface{}
	_ = json.Unmarshal([]byte(StandardDeltaPackWithDeltaOps), &deltaData1)
	err = websocket.JSON.Send(ws, deltaData1)
	if err != nil {
		fmt.Println("Error sending delta ops message: ", err.Error())
	}

	// Wait 1 seconds
	time.Sleep(1 * time.Second)

	var actualEvents = getEvents(k, &iterator)
	validateSequence(buildStandardExpectedKinesisResults(2), actualEvents, expectedKinesisProps{GameID: tester.GameID, BroadcasterId: tester.BroadcasterIDs, IsServerData: true})
}
