package e2e_utils

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"golang.org/x/net/websocket"
)

func (tester *eceImpl) TestKinesisWithFlush() {
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData)
	k, iterator := tester.getIterator(tester.BroadcasterIDs, "21779")

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestKinesisWithRefresh", ws)

	// No worker is needed, since this is mainly for kinesis test

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	var flushData map[string]interface{}
	_ = json.Unmarshal([]byte(StandardFlushPack), &flushData)

	// Send flush pack, should not impact kinesis out put
	err = websocket.JSON.Send(ws, flushData)
	if err != nil {
		fmt.Println("Error sending flush message: ", err.Error())
	}

	for i := 0; i < 12; i++ {
		// Send right delta pack
		var deltaData1 map[string]interface{}
		_ = json.Unmarshal([]byte(StandardDeltaPackWithDeltaOps), &deltaData1)
		err = websocket.JSON.Send(ws, deltaData1)
		if err != nil {
			fmt.Println("Error sending delta ops message: ", err.Error())
		}
	}

	// Send another flush pack, should not impact kinesis out put
	err = websocket.JSON.Send(ws, flushData)
	if err != nil {
		fmt.Println("Error sending flush message: ", err.Error())
	}

	// Wait 2 seconds for message to be fully published
	time.Sleep(2 * time.Second)

	var actualEvents = getEvents(k, &iterator)
	validateSequence(buildStandardExpectedKinesisResults(13), actualEvents, expectedKinesisProps{GameID: tester.GameID, BroadcasterId: tester.BroadcasterIDs, IsServerData: true})
}
