package e2e_utils

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"golang.org/x/net/websocket"
)

func (tester *eceImpl) TestKinesisWithRefresh() {
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData)
	k, iterator := tester.getIterator(tester.BroadcasterIDs, "21779")

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestKinesisWithRefresh", ws)

	// No worker is needed, since this is mainly for kinesis test

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	for i := 0; i < 2; i++ {
		// Send bad delta pack
		var deltaData1 map[string]interface{}
		_ = json.Unmarshal([]byte(BadDeltaPack), &deltaData1)
		err = websocket.JSON.Send(ws, deltaData1)
		if err != nil {
			fmt.Println("Error sending delta ops message: ", err.Error())
		}
	}

	// Send refresh package
	var refreshData map[string]interface{}
	_ = json.Unmarshal([]byte(StandardRefresh), &refreshData)

	// Send refresh pack
	err = websocket.JSON.Send(ws, refreshData)
	if err != nil {
		fmt.Println("Error sending refresh message: ", err.Error())
	}

	// Wait 1 seconds to send delta pack
	time.Sleep(1 * time.Second)

	for i := 0; i < 12; i++ {
		// Send right delta pack
		var deltaData1 map[string]interface{}
		_ = json.Unmarshal([]byte(StandardDeltaPackWithDeltaOps), &deltaData1)
		err = websocket.JSON.Send(ws, deltaData1)
		if err != nil {
			fmt.Println("Error sending delta ops message: ", err.Error())
		}
	}

	// Wait 3 seconds for message to be fully published
	time.Sleep(3 * time.Second)

	var actualEvents = getEvents(k, &iterator)
	results := []kinesisResult{{Type: kinesisFirstFullState}, {Type: kinesisGeneralFullState}}
	for i := 0; i < 12; i++ {
		if i == 9 {
			results = append(results, kinesisResult{Type: kinesisGeneralFullState})
		} else {
			results = append(results, kinesisResult{Type: kinesisDeltaState})
		}
	}
	validateSequence(results, actualEvents, expectedKinesisProps{GameID: tester.GameID, IsServerData: true, BroadcasterId: tester.BroadcasterIDs})
}
