package e2e_utils

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"code.justin.tv/devhub/mdaas-ingest/models"

	"golang.org/x/net/websocket"
)

// Send empty token connect pack, should not see connected: true, and delta will not be processed (seeing errors)
func (tester *eceImpl) TestNotAuthedConnectPack() {
	// Send empty token connect pack
	connectPack := replaceTokenAndBroadcasterIDs("wefwescsd", tester.BroadcasterIDs, StandardConnectionData)

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestNotAuthedConnectPack", ws)

	spinUpValidationWorker(validateNotConnected, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	// Wait 1 seconds to send delta pack
	time.Sleep(1 * time.Second)

	// Send delta pack
	var deltaData1 map[string]interface{}
	_ = json.Unmarshal([]byte(StandardDeltaPackWithDeltaOps), &deltaData1)
	err = websocket.JSON.Send(ws, deltaData1)
	if err != nil {
		fmt.Println("Error sending delta ops message: ", err.Error())
	}

	// Wait 3 seconds
	time.Sleep(3 * time.Second)
}

func (tester *eceImpl) TestNotAuthedAppTokenPublishUnauthorizedUser() {
	// Send empty token connect pack
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, "123455", StandardConnectionData)

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestNotAuthedAppTokenPulishUnauthorizedUser", ws)

	spinUpValidationWorker(validateNotConnected, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	// Wait 1 seconds to send delta pack
	time.Sleep(1 * time.Second)

	// Send delta pack
	var deltaData1 map[string]interface{}
	_ = json.Unmarshal([]byte(StandardDeltaPackWithDeltaOps), &deltaData1)
	err = websocket.JSON.Send(ws, deltaData1)
	if err != nil {
		fmt.Println("Error sending delta ops message: ", err.Error())
	}

	// Wait 3 seconds
	time.Sleep(3 * time.Second)
}

func validateNotConnected(count int, result map[string]interface{}) {
	fmt.Println("Received ", result)
	switch count {
	case 1:
		validateResp(result, models.NotWhitelistedAppToken, "receive not authed app token for user msg")
	default:
		encounterUnexpectedResp(result)
	}
}
