package e2e_utils

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"code.justin.tv/devhub/mdaas-ingest/models"

	"golang.org/x/net/websocket"
)

// Send 11 delta packs all together, got rate limit error
func (tester *eceImpl) TestSendDeltaTooFastExceedLimit() {
	// Send empty token connect pack
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData)

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestSendDeltaTooFastExceedLimit", ws)

	spinUpValidationWorker(validateRateLimited, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	// Wait 1 seconds to send delta pack
	time.Sleep(1 * time.Second)

	// Should see one rate limit exceeding message (since rate count includes connect pack)
	for i := 1; i <= 64; i++ {
		// Send delta pack
		var deltaData1 map[string]interface{}
		_ = json.Unmarshal([]byte(StandardDeltaPackWithDeltaOps), &deltaData1)
		err = websocket.JSON.Send(ws, deltaData1)
		if err != nil {
			fmt.Println("Error sending delta ops message: ", err.Error())
		}
	}

	// Wait 5 seconds
	time.Sleep(5 * time.Second)
}

func validateRateLimited(count int, result map[string]interface{}) {
	fmt.Println("Received ", result)
	switch count {
	case 1:
		validateConnectPack(result)
	case 2:
		validateResp(result, models.DeltaRateLimitExceeded, "rate limit exceed message")
	default:
		encounterUnexpectedResp(result)
	}
}
