package e2e_utils

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"code.justin.tv/devhub/mdaas-ingest/models"

	"golang.org/x/net/websocket"
)

func (tester *eceImpl) TestRespondToErrorWithRefreshNewState() {
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData)

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestRespondToErrorWithRefreshNewState", ws)

	spinUpValidationWorker(validateRefresh, ws)

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	// Wait 1 seconds to send delta pack
	time.Sleep(1 * time.Second)

	// Send delta pack, should see errors
	var deltaData1 map[string]interface{}
	_ = json.Unmarshal([]byte(BadDeltaPack), &deltaData1)
	err = websocket.JSON.Send(ws, deltaData1)
	if err != nil {
		fmt.Println("Error sending delta ops message: ", err.Error())
	}

	// Wait 1 seconds to send delta pack
	time.Sleep(1 * time.Second)

	// Send refresh package
	var refreshData map[string]interface{}
	_ = json.Unmarshal([]byte(StandardRefresh), &refreshData)

	// Send refresh pack
	err = websocket.JSON.Send(ws, refreshData)
	if err != nil {
		fmt.Println("Error sending refresh message: ", err.Error())
	}

	// Wait 1 seconds to send delta pack
	time.Sleep(1 * time.Second)

	// Send delta pack, should NOT see errors
	err = websocket.JSON.Send(ws, deltaData1)
	if err != nil {
		fmt.Println("Error sending delta ops message: ", err.Error())
	}

	// Wait 3 seconds
	time.Sleep(3 * time.Second)
}

func validateRefresh(count int, result map[string]interface{}) {
	fmt.Println("Received ", result)
	switch count {
	case 1:
		validateConnectPack(result)
	case 2:
		validateResp(result, models.DeltaInvalid, "delta invalid message")
	default:
		encounterUnexpectedResp(result)
	}
}
