package e2e_utils

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"code.justin.tv/devhub/mdaas-ingest/models"

	"golang.org/x/net/websocket"
)

// Send valid connect pack and delta pack, monitor results
func (tester *eceImpl) TestSimulatingWholeFlow() {
	connectPack := replaceTokenAndBroadcasterIDs(tester.Token, tester.BroadcasterIDs, StandardConnectionData)

	// connect
	ws, err := tester.connect()
	if err != nil {
		log.Fatal(err)
	}

	defer closeConnection()("TestSimulatingWholeFlow", ws)

	// receive
	go func() {
		count := 0
		for {
			var m map[string]interface{}
			err := websocket.JSON.Receive(ws, &m)
			if err != nil {
				fmt.Println("Error receiving message: ", err.Error())
				break
			}
			count++
			validateFullFlow(count, m, ws)
			if count == 3 {
				break
			}

			if count == 2 {
				// Send refresh package
				var refreshData map[string]interface{}
				_ = json.Unmarshal([]byte(StandardRefresh), &refreshData)

				// Send refresh pack
				err = websocket.JSON.Send(ws, refreshData)
				if err != nil {
					log.Println("Error sending refresh message: ", err.Error())
				}

				var deltaData map[string]interface{}
				_ = json.Unmarshal([]byte(BadDeltaPack), &deltaData)
				err = websocket.JSON.Send(ws, deltaData)
				if err != nil {
					log.Println("Error sending delta ops message: ", err.Error())
				}
				// Send delta pack, should NOT see errors
				err = websocket.JSON.Send(ws, deltaData)
				if err != nil {
					log.Println("Error sending delta ops message: ", err.Error())
				}

				var flushData map[string]interface{}
				_ = json.Unmarshal([]byte(StandardFlushPack), &flushData)

				// Send flush pack
				err = websocket.JSON.Send(ws, flushData)
				if err != nil {
					log.Println("Error sending flush message: ", err.Error())
				}
			}
		}
	}()

	var connectData map[string]interface{}
	_ = json.Unmarshal([]byte(connectPack), &connectData)

	// Send connect pack
	err = websocket.JSON.Send(ws, connectData)
	if err != nil {
		fmt.Println("Error sending connect message: ", err.Error())
	}

	for i := 1; i < 10; i++ {
		// Wait 1 seconds to send delta pack
		time.Sleep(2 * time.Second)

		// Send delta pack
		var deltaData1 map[string]interface{}
		_ = json.Unmarshal([]byte(StandardDeltaPackWithDeltaOps), &deltaData1)
		err = websocket.JSON.Send(ws, deltaData1)
		if err != nil {
			fmt.Println("Error sending delta ops message: ", err.Error())
		}
	}

	// Send delta pack, should see errors
	var deltaData1 map[string]interface{}
	_ = json.Unmarshal([]byte(BadDeltaPack), &deltaData1)
	err = websocket.JSON.Send(ws, deltaData1)
	if err != nil {
		fmt.Println("Error sending delta ops message: ", err.Error())
	}

	// Wait 3 seconds
	time.Sleep(3 * time.Second)
}

func validateFullFlow(count int, result map[string]interface{}, ws *websocket.Conn) {
	fmt.Println("Received ", result)
	switch count {
	case 1:
		validateConnectPack(result)
	case 2:
		validateResp(result, models.DeltaInvalid, "delta invalid message")
	case 3:
		validateResp(result, models.Flushed{Flushed: "09DSLKJ392"}, "flushed message")
		ws.Close()
	default:
		encounterUnexpectedResp(result)
	}
}
