package e2e_utils

import (
	"encoding/json"
	"fmt"
	"io"
	"os"
	"strings"

	"github.com/fatih/color"
	"golang.org/x/net/websocket"

	"code.justin.tv/devhub/mdaas-ingest/models"
)

type closeFunc func(name string, ws *websocket.Conn)

type validationFunc func(count int, msg map[string]interface{})

func validateConnectPack(msg map[string]interface{}) {
	validateResp(msg, models.ConnectedMsg{Connected: true}, "connected message")
}

func validateResp(msg map[string]interface{}, expected interface{}, printMsg string) {
	receivedStr, _ := json.Marshal(msg)
	expectedStr, _ := json.Marshal(expected)

	ifDiff := strings.EqualFold(string(receivedStr), string(expectedStr))
	if !ifDiff {
		fmt.Println(msg)
		fmt.Println("Error validating ", printMsg)
		os.Exit(1)
	}

	fmt.Println("Received expected ", printMsg)
}

func encounterUnexpectedResp(msg map[string]interface{}) {
	fmt.Println(msg)
	fmt.Println("Unexpected message for current test.")
	os.Exit(1)
}

func spinUpValidationWorker(validate validationFunc, ws *websocket.Conn) {
	go func() {
		count := 1
		for {
			var m map[string]interface{}
			err := websocket.JSON.Receive(ws, &m)
			if err != nil {
				if !strings.Contains(err.Error(), "use of closed network connection") && err != io.EOF {
					fmt.Println("Error receiving message: ", err.Error())
				}
				break
			}
			// Put results into channel
			validate(count, m)
			count++
		}
	}()
}

func validateOnlyConnect(count int, result map[string]interface{}) {
	fmt.Println("Received ", result)
	switch count {
	case 1:
		validateConnectPack(result)
	default:
		encounterUnexpectedResp(result)
	}
}

func closeConnection() closeFunc {
	return func(name string, ws *websocket.Conn) {
		color.Green("All tests passed for %s\n", name)
		ws.Close()
	}
}

func replaceBroadcasterID(broadcasterIDsStr string, data string) string {
	broadcasterIDs := strings.Split(broadcasterIDsStr, ",")
	jsonMap := make(map[string]interface{})
	err := json.Unmarshal([]byte(data), &jsonMap)
	if err != nil {
		panic(err)
	}

	jsonMap["connect"].(map[string]interface{})["broadcaster_ids"] = broadcasterIDs

	completeConnectPack, _ := json.Marshal(jsonMap)
	return string(completeConnectPack)
}

func replaceTokenAndBroadcasterIDs(token string, ids string, connectionData string) string {
	tokeReplaced := replaceToken(token, connectionData)
	return replaceBroadcasterID(ids, tokeReplaced)
}

func replaceToken(token string, connectionData string) string {
	jsonMap := make(map[string]interface{})
	err := json.Unmarshal([]byte(connectionData), &jsonMap)
	if err != nil {
		panic(err)
	}

	jsonMap["connect"].(map[string]interface{})["token"] = token

	completeConnectPack, _ := json.Marshal(jsonMap)
	return string(completeConnectPack)
}

func deepCopy(data map[string]interface{}) map[string]interface{} {
	s, _ := json.Marshal(data)
	var result map[string]interface{}
	_ = json.Unmarshal(s, &result)
	return result
}
