package config

import (
	"encoding/json"
)

type Config struct {
	SecretName         string `yaml:"secretManager"`
	Secrets            Secrets
	Env                string
	FanoutKinesis      bool
	DevSNSArn          string `yaml:"metadataDevARN"`
	ProdSNSArn         string `yaml:"metadataProdARN"`
	OwlHost            string `yaml:"owlHost"`
	DebugLogsFirehose  string `yaml:"debugLogsFirehose"`
	InterpolHost       string `yaml:"interpolHost"`
	S2SCallerName      string `yaml:"s2sCallerName"`
	AllowlistTableName string `yaml:"allowlistTableName"`
}

type Secrets struct {
	RollbarToken string `json:"rollbar_token"`
}

var config Config

func init() {
	config = Config{
		Env:           "development",
		FanoutKinesis: true,
		Secrets:       Secrets{},
	}
}

func LoadConfigs(env string, fanout *bool) error {
	err := loadEnvConfigs(env, fanout)
	if err != nil {
		return err
	}

	if secretsStr, err := getSecret(config.SecretName); err != nil {
		return err
	} else {
		var secrets Secrets
		err := json.Unmarshal([]byte(secretsStr), &secrets)
		if err == nil {
			config.Secrets = secrets
		} else {
			return err
		}
	}

	return nil
}

func GetConfigs() Config {
	return config
}

func GetAccountID() string {
	if config.Env == prod {
		return "433343386846"
	} else {
		return "797743463538"
	}
}
