// Package config Code generated by go-bindata. (@generated) DO NOT EDIT.
// sources:
// config/data/config-dev.yaml
// config/data/config-prod.yaml
// config/data/config-staging.yaml
package config

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

// Name return file name
func (fi bindataFileInfo) Name() string {
	return fi.name
}

// Size return file size
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}

// Mode return file mode
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}

// ModTime return file modify time
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}

// IsDir return file whether a directory
func (fi bindataFileInfo) IsDir() bool {
	return fi.mode&os.ModeDir != 0
}

// Sys return file is sys mode
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _configDataConfigDevYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x9c\x91\xc1\x8e\x9b\x30\x10\x86\xef\x3c\x45\x6e\x3e\x99\x4d\x81\x14\xf0\x8d\x60\x68\xa2\x6c\x52\xd4\xec\x56\x6a\x6e\x43\x18\x11\x4b\xc6\x46\x1e\x2f\x68\xdf\xbe\x5a\xba\x69\xd5\xf6\xb6\x47\xfb\xff\x66\x3e\xe9\x1f\x3b\xeb\x9d\x25\x2f\x56\xec\xe6\xfd\x48\xe2\xe1\xc1\xce\x3a\x1c\x9d\xed\x42\x65\x3c\x3a\x03\x3a\x7c\x21\x3e\x23\x79\x1e\x85\x7e\x56\xfe\x7a\x0b\xfd\xc4\x02\xc2\xab\x43\x7f\x04\x03\x3d\x3a\xb1\x62\x8d\x53\x03\xb8\xd7\xf3\xf2\x1d\x55\x59\x9e\x67\xd1\x9a\xcf\xdb\x61\x7f\x8a\xf7\xed\xb9\xb5\x9e\x05\x03\x7a\xe8\xc0\x83\xc4\xa9\xf8\x76\x12\x2b\x06\xce\x08\x98\x49\x90\x21\xf1\xdb\x22\xd2\x3c\x4d\x93\x38\xf9\x1c\x6f\xe2\x4c\x48\x9c\xce\x86\x9e\xec\xa8\xae\xc4\x25\x4e\xc7\xf7\x1d\x45\x14\x47\x79\xb6\xae\x79\xbe\xad\x9e\x4f\xcf\x9b\xaf\xb1\x3c\xcb\x3f\x8a\xc6\xd9\xee\x63\x8e\xb7\xc9\xbb\x24\x4e\xcb\x24\xaf\xab\x88\x7f\xca\xca\xa6\x38\x56\x45\xb2\xdb\x96\x3f\x58\xd0\x61\xfb\xd2\x3f\xda\x9e\x6a\xe5\xf0\x66\x09\xc5\x8a\x49\x9c\xf6\xa6\x47\xf2\xf2\x1e\xf2\xff\x30\xfe\xa5\xba\x5c\xea\x26\x95\xbb\xf2\x20\x59\xb0\x34\x3c\xda\x7f\x2f\xa0\xba\xbf\x8a\x8e\xa8\x04\xad\xd1\x9d\x60\x78\xf3\x0c\x1d\x00\x71\xb5\xa8\x78\x87\x13\x0b\x40\x6b\x3b\x6b\x45\xfe\x09\x5a\x8d\xef\x98\xc4\x49\xbe\x1a\x18\x6c\x71\x4f\xf9\xaf\xb7\xdc\x2e\xd8\x26\x4f\xb3\xa4\x2e\xd7\x7c\x53\x1e\xe4\xf7\x43\x73\x39\xee\x1e\x1b\x16\xfc\x0c\x00\x00\xff\xff\x4e\x85\xb3\x9e\x10\x02\x00\x00")

func configDataConfigDevYamlBytes() ([]byte, error) {
	return bindataRead(
		_configDataConfigDevYaml,
		"config/data/config-dev.yaml",
	)
}

func configDataConfigDevYaml() (*asset, error) {
	bytes, err := configDataConfigDevYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/data/config-dev.yaml", size: 528, mode: os.FileMode(420), modTime: time.Unix(1593473285, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configDataConfigProdYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x9c\x91\xc1\x72\xda\x30\x18\x84\xef\x7e\x0a\x6e\x3a\xc9\x31\x92\xc1\xb6\x6e\xc4\xc6\xa5\x01\x02\x29\x94\x4c\x72\xfb\x83\x35\x46\x33\xb2\xe4\xea\x57\xec\xc9\xdb\x77\xec\x42\x3b\x6d\x6f\x39\xae\x76\xa5\x4f\xb3\x6b\x7b\xbd\xb2\xe8\xc5\x84\x5c\xbc\x6f\x51\xdc\xdd\xd9\x5e\x87\xad\xb3\x55\xa8\x8c\x97\xce\x80\x0e\xdf\x91\xf6\x12\x3d\x65\xa1\xef\x95\x3f\x5f\x42\xdf\x91\x00\xe5\xd9\x49\xbf\x05\x03\xb5\x74\x62\x42\xf6\x4e\x35\xe0\x3e\x0e\xe3\x31\x5b\xa6\x59\x96\xb2\x88\xee\xdd\x8f\xa7\x6e\xcd\x67\xbe\x39\xc4\x24\x68\xa4\x87\x0a\x3c\x14\xb2\x5b\x7c\x7b\x14\x13\x02\xce\x08\xe8\x51\xa0\x41\xf1\x9b\x22\x62\xce\x79\xcc\x79\x3a\x4f\xe3\xb9\xd8\x3b\x5b\x1d\x0c\x1e\x6d\xab\xce\x48\x0b\xd9\x6d\xaf\x8f\x2c\x18\x67\x59\x1a\x95\xf4\xb4\x5d\xed\x1e\x96\xc7\x97\x2f\xf7\xbb\xf9\x1f\xc6\x70\xef\x93\x90\x41\xdd\x28\x3c\xc9\xe3\xac\x5c\x32\x3a\x7d\x7e\x5d\x6d\xf8\xe1\x25\x59\x9f\x92\x1d\x09\x2a\xf9\xf6\x5e\x6f\x6c\x8d\xa5\x72\xf2\x62\x51\x8e\x15\xd8\xea\xab\xa9\x25\xfa\xe2\xe6\xd2\xff\x72\x74\xfa\xfc\x90\x4c\x9f\x8a\x75\x91\x6f\x22\x46\x82\xb1\xe5\xd6\xfe\xbb\x82\xaa\xfe\x2a\x9b\x61\x0e\x5a\x4b\xf7\x08\xcd\x40\x6a\x2a\x00\xa4\x6a\x64\xd1\x61\x2c\x12\x80\xd6\xb6\xd7\x0a\xfd\x11\xde\xb4\xbc\xe6\x86\x1f\x15\x1f\x06\x1a\xbb\xb8\xd9\xf4\x97\x2e\xee\xc7\xdc\x2c\x4b\xd2\xb8\xcc\x23\x3a\x8d\xf6\xab\xcd\xeb\xba\xfc\x9e\xcf\x4e\x29\x09\x7e\x06\x00\x00\xff\xff\x53\xa9\xc4\x17\x17\x02\x00\x00")

func configDataConfigProdYamlBytes() ([]byte, error) {
	return bindataRead(
		_configDataConfigProdYaml,
		"config/data/config-prod.yaml",
	)
}

func configDataConfigProdYaml() (*asset, error) {
	bytes, err := configDataConfigProdYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/data/config-prod.yaml", size: 535, mode: os.FileMode(420), modTime: time.Unix(1593473252, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configDataConfigStagingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x9c\x91\xc1\x8e\x9b\x30\x10\x86\xef\x3c\x45\x6e\x3e\x99\x4d\x81\x14\xf0\x8d\x60\x68\xa2\x6c\x52\x54\x76\x2b\x35\xb7\x21\x8c\x88\x25\x63\x47\x1e\x2f\x68\xdf\xbe\x5a\xba\x69\xd5\xf6\xb6\x47\xfb\xff\x66\x3e\xe9\x1f\x3b\xeb\x9d\x25\x2f\x56\xec\xea\xfd\x8d\xc4\xc3\x83\x9d\x75\x48\x1e\x06\x65\x86\x50\x19\x8f\xce\x80\x0e\x5f\x88\xcf\x48\x9e\x47\xa1\x9f\x95\xbf\x5c\x43\x3f\xb1\x80\xf0\xe2\xd0\x1f\xc1\xc0\x80\x4e\xac\x58\xe3\xd4\x08\xee\xb5\x5d\xbe\xa3\x2a\xcb\xf3\x2c\x5a\xf3\x79\x3b\xee\x4f\xf1\xbe\x6b\x3b\xeb\x59\x30\xa2\x87\x1e\x3c\x48\x9c\x8a\x6f\x27\xb1\x62\xe0\x8c\x80\x99\x04\x19\x12\xbf\x2d\x22\xcd\xd3\x34\x89\x93\xcf\xf1\x26\xce\x84\xc4\xa9\x35\xf4\x64\x6f\xea\x42\x5c\xe2\x74\x7c\xdf\x51\x44\x71\x94\x67\xeb\x9a\xe7\xdb\xea\xf9\xf4\xbc\xf9\x1a\xcb\x56\xfe\x51\x34\xce\xf6\x1f\x73\xbc\x4d\xde\x25\x71\x5a\x26\x79\x5d\x45\xfc\x53\x56\x36\xc5\xb1\x2a\x92\xdd\xb6\xfc\xc1\x82\x1e\xbb\x97\xe1\xd1\x0e\x54\x2b\x87\x57\x4b\x28\x56\x4c\xe2\xb4\x37\x03\x92\x97\xf7\x90\xff\x87\xf1\x2f\xd5\xf9\x5c\x37\xa9\xdc\x95\x07\xc9\x82\xa5\xe1\x9b\xfd\xf7\x08\xaa\xff\xab\xe8\x88\x4a\xd0\x1a\xdd\x09\xc6\x37\xcf\xd8\x03\x10\x57\x8b\x8a\xf7\x38\xb1\x00\xb4\xb6\xb3\x56\xe4\x9f\xa0\xd3\xf8\x8e\x49\x9c\xe4\xab\x81\xd1\x16\xf7\x94\xff\x7a\xcb\xed\x82\x6d\xf2\x34\x4b\xea\x72\xcd\x37\xe5\x41\x7e\x3f\x34\xe7\xe3\xee\xb1\x61\xc1\xcf\x00\x00\x00\xff\xff\x75\xbe\x93\xfd\x13\x02\x00\x00")

func configDataConfigStagingYamlBytes() ([]byte, error) {
	return bindataRead(
		_configDataConfigStagingYaml,
		"config/data/config-staging.yaml",
	)
}

func configDataConfigStagingYaml() (*asset, error) {
	bytes, err := configDataConfigStagingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/data/config-staging.yaml", size: 531, mode: os.FileMode(420), modTime: time.Unix(1593473298, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"config/data/config-dev.yaml":     configDataConfigDevYaml,
	"config/data/config-prod.yaml":    configDataConfigProdYaml,
	"config/data/config-staging.yaml": configDataConfigStagingYaml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"config": &bintree{nil, map[string]*bintree{
		"data": &bintree{nil, map[string]*bintree{
			"config-dev.yaml":     &bintree{configDataConfigDevYaml, map[string]*bintree{}},
			"config-prod.yaml":    &bintree{configDataConfigProdYaml, map[string]*bintree{}},
			"config-staging.yaml": &bintree{configDataConfigStagingYaml, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
