# Dependency Management

We switched to [Go Modules](https://github.com/golang/go/wiki/Modules) for depenency management. 

## Adding dependency

Run go get to add a new dependency to this project:

Example:

```$xslt
go get github.com/go-chi/chi@v4.0.1
```

Then please run to clean up the dependency:
```
make clean-vendor
```

For more information, please refer to a [recommended reading](https://medium.com/@adiach3nko/package-management-with-go-modules-the-pragmatic-guide-c831b4eaaf31).

### Adding a tool
You would want to navigate to the [tooling file](https://git.xarth.tv/devhub/mdaas-ingest/blob/master/tools.go) to add a new tooling dependency. Then run a `make test` or `make clean` to get it into the vendor file. Remember to submit that to PR.

The user runs the tool using “go run github.com/maxbrunsfeld/counterfeiter/v6 <args>”, or uses them in go generate statements like: “//go:generate go run github.com/maxbrunsfeld/counterfeiter/v6 <args>”. 
Critically, “go run” will use the version of counterfeiter specified in go.mod, even if the tool is globally installed at a different version.

A good reading would be [Managing Go Tools with Go Modules](https://docs.google.com/document/d/1q8kMoSOBz3aiDtmHwvH9ugRfWHGTQvJSbLqVB6Nv9Gk/edit?usp=sharing).

While detected some tool packages not compatible with Go Modules, so in that way, we have to add it in the `make setup` step and run it directly using the binary from `/bin` file.
