# Development Guide

## Run the service on 8080 locally (default local setup):
```
go run cmd/mdaas-ingest/main.go
```

## Changing configs
If you make changes to `config-<env>.yaml` files, you will need to run `make config` to regenerate the binary for your changes to be effective.

## Ask for AWS account access
Ask in #mdaas slack channel for AWS access to `twitch-mdaas-ingest-dev` and `twitch-mdaas-ingest-prod` account.

## Ask github access 
Ask in #mdaas slack channel for this repo's edit access.

## Set environment variable 
```
export ENV=development
```
## Set AWS credentials
Edit your aws credentials file and change the default credential to your key and secrets got from `twitch-mdaas-ingest-dev` account.
```
vi ~/.aws/credentials
```

## Get an app token or user token
This is the step by step guide to get an app token:
- Create an app in https://dev.twitch.tv/console/apps/create, get the client id and secret.

- Use the client ID and secret from step 1, fill in the following curl command
```
curl -X POST \
  'https://id.twitch.tv/oauth2/token?client_id=<client_id_to_fill_in>&client_secret=<client_secret_to_fill_in>&grant_type=<client_credentials>&'
```

There will be a field named `access_token` in the response, copy the value of it and you will need to set it as an env variable with key "TEST_TOKEN"(you can refer the code here https://git.xarth.tv/devhub/mdaas-ingest/blob/master/cmd/e2e_test/end_to_end.go#L15). No need to add "Bearer" or "Oauth" as prefix.

If you want to get user token, pass the client id you created into the url below and put that into your browser (logged in in Twitch), hit enter:

Note your redirect URI should match the one in your app.
```
https://id.twitch.tv/oauth2/authorize?response_type=token&client_id=<your_client_id>&redirect_uri=http://localhost
```

Then grab the token field returned from the request above.

## Whitelist your client id:
You need to whitelist your client ID for accessing some games by adding a new E2 entry in [Vienna](https://vienna.xarth.tv/e2). Click on the purple "Allowlist E2 Client" button and fill out the form. For the organization field, use "Twitch Gaming".

If you can't access the page, ask a team member to add you to the necessary LDAP groups.

## More on how to get your app token to publish data for a certain user.
- Log in your browser
- Authorize your app as this user (Note your redirect URI should match the one in your app):
```
https://id.twitch.tv/oauth2/authorize?response_type=token&client_id=<your_client_id>&redirect_uri=http://localhost
```

- Check if it succeed from owl (need to be on twitch internal network instead of WPA2):
```
curl 'https://owl.prod.internal.us-west-2.twitch.tv/authorizations?owner_id=<user_id>'
```

`client_id_canonical` is what you want to check.

## Flags
- fanout-kinesis: a boolean to configure if we want kinesis fanout for MDaaS, default to disabled mode because not foresee any uses.
- cert: if self-cert enabled in the server.
- log: set logging level: [trace,debug,info,warning,error].
- health-check: health check path, default to `/ping`.
- port: the port running MDaaS, local default to 8080, prod and staging default to 80.
