# E2E tests
Note that E2E tests are used to validate our features work as expected, so we have tests on many different situations, so it is taking time to set up and run, if you fail to running it after the following steps, feel free to just ping in #mdaas to get our help!

## Run E2E tests locally
```
go run cmd/mdaas-ingest/main.go
```

## Set test environment variables:
Export or in your bash file, test token works for all tests without "user token" suffix. User token works for all tests with user token suffix.
```
export TEST_TOKEN=<your_app_token>
export USER_TOKEN=<your_user_token>
```

## Run E2E tests in cmd directory (replace your own e2e test name, env and broadcaster id), either specify test name or run them all (leaving name flag blank).

```
go run cmd/e2e_test/end_to_end.go -env=local -name=TestKinesisHappyPath -broadcaster=131180913
```

## Run E2E tests in docker
Make sure you set up the following 2 ENV variables using credentials from account `twitch-mdaas-ingest-dev`:
1. `AWS_ACCESS_KEY_ID`
2. `AWS_SECRET_ACCESS_KEY`

Notice that setting up `AWS_PROFILE` **doesn't mean** it will set these 2 ENV variables automatically.
After setting up those 2 ENV variables, run:
```
make e2e-test
```

## Run E2E tests against prod or staging:

Please note that staging with app token might not work since staging MDaaS is using owl staging, and owl staging might be behind prod data, then authentication will fail.

```
go run cmd/e2e_test/end_to_end.go -env=<prod|staging>  -name=TestKinesisHappyPath -broadcaster=131180913
```

## Run SNS tests
- This test should not be mainly running on staging, even though the env tag is set to `dev`, it will still affect production SNS.
- SNS test such as `TestSNSPublishNormalPath` will need to consume result in a SQS on staging. So in order to run it, you will need to hook your own SNS topic with `e2e-test-validator` SQS, so your result will be piped in.
