# PR and Deployment Guidelines
wiki: https://wiki.twitch.com/display/DS/MDaaS+Deployment+and+Change+Management

## Submitting PR
- Create a PR to merge to `develop` branch (DO NOT MERGE TO MASTER DIRECTLY!!!)
- Follow the PR template to fill in your pull request details
- Get PR Approved and merged to `develop`
- You should make sure it is working as expected on staging

## Merge your code
- You PR will be automatically deployed to Staging if merged to `develop` branch
- Then you submit a new PR after that to merge into `master` from `develop`


## Deployment
### Staging
- The deployment is automatically done after your code is merged into branch `develop`.

### PROD
- Cut a JIRA ticket under Mdaas project, set the type as "Change Request".
- Ask an approval for the ticket in #e2-mdaas-priv.
- After getting the approval, go to Jenkins: https://jenkins-og.xarth.tv/job/devhub/job/mdaas-ingest/
- Click build now, and wait til the button "Deploy Canary" shows up (~ 2mins).
- Click the Deploy Canary button.
- Validating all metrics, errors and logs after canary deployment.
- Go to Jenkins: https://jenkins-og.xarth.tv/job/devhub/job/mdaas-ingest/ and the button "Deploy to All".
- Validating all metrics, errors and logs after prod deployment.

### Checkings after deployment
- run e2e tests on prod
  ```
    // make sure change the aws profile to twitch-mdaas-ingest-prod first.
    export USER_TOKEN=${your user token (without "Oauth")}
    go run cmd/e2e_test/end_to_end.go -env=prod -name=${path you want to test} -broadcaster=${your broad caster ID}
  ```
- check cloud watch dashboard to make sure metrics look good.

## Tips
- The button click should be within 5 min, time exceeding that will be a timeout, and you will need to rebuild to trigger deploy.
- If you accidentally merge to `master` before to `develop`, make them in sync again. The two branches should be in sync, or at least `master` should not advance `develop`.
