package kinesis

import "time"

type Config struct {
	RoleARN           string
	AWSRegion         string
	RetryDelay        time.Duration
	RetryCount        int
	DebugLogsFirehose string
}

const (
	defaultAWSRegion  = "us-west-2"
	defaultRetryDelay = 100 * time.Millisecond
	defaultRetryCount = 10
)

func (c *Config) awsRegion() string {
	if c.AWSRegion == "" {
		return defaultAWSRegion
	}
	return c.AWSRegion
}

func (c *Config) retryDelay() time.Duration {
	if c.RetryDelay == 0 {
		return defaultRetryDelay
	}
	return c.RetryDelay
}

func (c *Config) retryCount() int {
	if c.RetryCount == 0 {
		return defaultRetryCount
	}
	return c.RetryCount
}
