package kinesis

import (
	"testing"

	"code.justin.tv/devhub/mdaas-ingest/internal/awsmocks"

	"github.com/stretchr/testify/suite"
)

type PublisherTest struct {
	suite.Suite
	publisher       Publisher
	mockKinesisAPI  *awsmocks.KinesisAPI
	mockFirehoseAPI *awsmocks.FirehoseAPI
}

func (suite *PublisherTest) SetupTest() {
	mKinesis := &awsmocks.KinesisAPI{}
	mFirehose := &awsmocks.FirehoseAPI{}
	p, _ := NewTestPublisher(mKinesis, mFirehose, &Config{})
	suite.publisher = p
	suite.mockKinesisAPI = mKinesis
	suite.mockFirehoseAPI = mFirehose
}

func (suite *PublisherTest) TearDownTest() {
	suite.mockKinesisAPI.AssertExpectations(suite.T())
	suite.mockFirehoseAPI.AssertExpectations(suite.T())
}

func TestRunProcessorSuite(t *testing.T) {
	suite.Run(t, new(PublisherTest))
}
