package metrics

import (
	"time"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	poller "code.justin.tv/amzn/TwitchTelemetryPollingCollector"
)

var goStatsPoller *poller.PollingCollector

func StartGoStatsCollection(l *FLogger) {
	if goStatsPoller == nil {
		sampleBuilder := &telemetry.SampleBuilder{ProcessIdentifier: ProcessIdentifier()}
		goStatsPoller = poller.NewGoStatsPollingCollector(1*time.Minute, sampleBuilder, Observer(), l)
	}
	goStatsPoller.Start()
}
